/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring6.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring6.expression.SPELContextPropertyAccessor;
import org.thymeleaf.spring6.expression.ThymeleafEvaluationContext;
import org.thymeleaf.util.Validate;

public final class ThymeleafEvaluationContextWrapper
implements IThymeleafEvaluationContext {
    private static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();
    private final EvaluationContext delegate;
    private final List<PropertyAccessor> propertyAccessors;
    private final TypeLocator typeLocator;
    private final List<MethodResolver> methodResolvers;
    private IExpressionObjects expressionObjects = null;
    private boolean requestParametersRestricted = false;
    private Map<String, Object> additionalVariables = null;

    public ThymeleafEvaluationContextWrapper(EvaluationContext delegate) {
        Validate.notNull((Object)delegate, (String)"Evaluation context delegate cannot be null");
        this.delegate = delegate;
        if (this.delegate instanceof ThymeleafEvaluationContext) {
            this.propertyAccessors = null;
            this.typeLocator = null;
            this.methodResolvers = null;
        } else {
            this.propertyAccessors = Stream.concat(Stream.of(SPELContextPropertyAccessor.INSTANCE, MAP_ACCESSOR_INSTANCE), this.delegate.getPropertyAccessors().stream().map(pa -> pa instanceof ReflectivePropertyAccessor ? new ThymeleafEvaluationContext.ThymeleafEvaluationContextACLPropertyAccessor((ReflectivePropertyAccessor)pa) : pa)).collect(Collectors.toList());
            this.typeLocator = new ThymeleafEvaluationContext.ThymeleafEvaluationContextACLTypeLocator(this.delegate.getTypeLocator());
            this.methodResolvers = this.delegate.getMethodResolvers().stream().map(mr -> mr instanceof ReflectiveMethodResolver ? new ThymeleafEvaluationContext.ThymeleafEvaluationContextACLMethodResolver((ReflectiveMethodResolver)mr) : mr).collect(Collectors.toList());
        }
    }

    public TypedValue getRootObject() {
        return this.delegate.getRootObject();
    }

    public List<ConstructorResolver> getConstructorResolvers() {
        return this.delegate.getConstructorResolvers();
    }

    public List<MethodResolver> getMethodResolvers() {
        return this.methodResolvers == null ? this.delegate.getMethodResolvers() : this.methodResolvers;
    }

    public List<PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors == null ? this.delegate.getPropertyAccessors() : this.propertyAccessors;
    }

    public TypeLocator getTypeLocator() {
        return this.typeLocator == null ? this.delegate.getTypeLocator() : this.typeLocator;
    }

    public TypeConverter getTypeConverter() {
        return this.delegate.getTypeConverter();
    }

    public TypeComparator getTypeComparator() {
        return this.delegate.getTypeComparator();
    }

    public OperatorOverloader getOperatorOverloader() {
        return this.delegate.getOperatorOverloader();
    }

    public BeanResolver getBeanResolver() {
        return this.delegate.getBeanResolver();
    }

    public void setVariable(String name, Object value) {
        if (this.additionalVariables == null) {
            this.additionalVariables = new HashMap<String, Object>(5, 1.0f);
        }
        this.additionalVariables.put(name, value);
    }

    public Object lookupVariable(String name) {
        Object result;
        if (this.expressionObjects != null && this.expressionObjects.containsObject(name) && (result = this.expressionObjects.getObject(name)) != null) {
            return result;
        }
        if (this.additionalVariables != null && this.additionalVariables.containsKey(name) && (result = this.additionalVariables.get(name)) != null) {
            return result;
        }
        return this.delegate.lookupVariable(name);
    }

    @Override
    public boolean isVariableAccessRestricted() {
        return this.requestParametersRestricted;
    }

    @Override
    public void setVariableAccessRestricted(boolean restricted) {
        this.requestParametersRestricted = restricted;
    }

    @Override
    public IExpressionObjects getExpressionObjects() {
        return this.expressionObjects;
    }

    @Override
    public void setExpressionObjects(IExpressionObjects expressionObjects) {
        this.expressionObjects = expressionObjects;
    }
}

