/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.web.webflux;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpCookie;
import org.springframework.util.MultiValueMap;
import org.thymeleaf.spring5.web.webflux.MultiValueMapUtil;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.IWebRequest;

public interface ISpringWebFluxWebRequest
extends IWebRequest {
    public URI getURI();

    default public String getScheme() {
        return this.getURI().getScheme();
    }

    default public String getServerName() {
        return this.getURI().getHost();
    }

    default public Integer getServerPort() {
        return this.getURI().getPort();
    }

    default public String getQueryString() {
        return this.getURI().getRawQuery();
    }

    public MultiValueMap<String, String> getHeaderMultiValueMap();

    default public boolean containsHeader(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.getHeaderMultiValueMap().containsKey((Object)name);
    }

    default public int getHeaderCount() {
        return this.getHeaderMultiValueMap().size();
    }

    default public Set<String> getAllHeaderNames() {
        return this.getHeaderMultiValueMap().keySet();
    }

    default public Map<String, String[]> getHeaderMap() {
        return MultiValueMapUtil.stringToStringArrayMultiMap(this.getHeaderMultiValueMap());
    }

    default public String getHeaderValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return (String)this.getHeaderMultiValueMap().getFirst((Object)name);
    }

    default public String[] getHeaderValues(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        List headerValueList = (List)this.getHeaderMultiValueMap().get((Object)name);
        return headerValueList.toArray(new String[headerValueList.size()]);
    }

    public MultiValueMap<String, String> getParameterMultiValueMap();

    default public boolean containsParameter(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.getParameterMultiValueMap().containsKey((Object)name);
    }

    default public int getParameterCount() {
        return this.getParameterMultiValueMap().size();
    }

    default public Set<String> getAllParameterNames() {
        return this.getParameterMultiValueMap().keySet();
    }

    default public Map<String, String[]> getParameterMap() {
        return MultiValueMapUtil.stringToStringArrayMultiMap(this.getParameterMultiValueMap());
    }

    default public String getParameterValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return (String)this.getParameterMultiValueMap().getFirst((Object)name);
    }

    default public String[] getParameterValues(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        List parameterValueList = (List)this.getParameterMultiValueMap().get((Object)name);
        return parameterValueList.toArray(new String[parameterValueList.size()]);
    }

    public MultiValueMap<String, HttpCookie> getCookieMultiValueMap();

    default public boolean containsCookie(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.getCookieMultiValueMap().containsKey((Object)name);
    }

    default public int getCookieCount() {
        return this.getCookieMultiValueMap().size();
    }

    default public Set<String> getAllCookieNames() {
        return this.getCookieMultiValueMap().keySet();
    }

    default public Map<String, String[]> getCookieMap() {
        return MultiValueMapUtil.cookieToStringArrayMultiMap(this.getCookieMultiValueMap());
    }

    default public String getCookieValue(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        HttpCookie cookie = (HttpCookie)this.getCookieMultiValueMap().getFirst((Object)name);
        return cookie == null ? null : cookie.getValue();
    }

    default public String[] getCookieValues(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        List cookieList = (List)this.getCookieMultiValueMap().get((Object)name);
        return (String[])cookieList.stream().map(HttpCookie::getValue).toArray(String[]::new);
    }

    public Object getNativeRequestObject();
}

