/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.view.reactive;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.http.MediaType;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.reactive.result.view.RedirectView;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.reactive.result.view.ViewResolverSupport;
import org.thymeleaf.spring5.ISpringWebFluxTemplateEngine;
import org.thymeleaf.spring5.view.reactive.ThymeleafReactiveView;
import org.thymeleaf.util.Validate;
import reactor.core.publisher.Mono;

public class ThymeleafReactiveViewResolver
extends ViewResolverSupport
implements ViewResolver {
    private static final Logger vrlogger = LoggerFactory.getLogger(ThymeleafReactiveViewResolver.class);
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    public static final String FORWARD_URL_PREFIX = "forward:";
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(ViewResolverSupport.DEFAULT_CONTENT_TYPE, MediaType.TEXT_EVENT_STREAM);
    private Function<String, RedirectView> redirectViewProvider = url -> new RedirectView(url);
    private boolean alwaysProcessRedirectAndForward = true;
    private Class<? extends ThymeleafReactiveView> viewClass = ThymeleafReactiveView.class;
    private String[] viewNames = null;
    private String[] excludedViewNames = null;
    private int order = Integer.MAX_VALUE;
    private final Map<String, Object> staticVariables = new LinkedHashMap<String, Object>(10);
    private int responseMaxChunkSizeBytes = Integer.MAX_VALUE;
    private ISpringWebFluxTemplateEngine templateEngine;

    public ThymeleafReactiveViewResolver() {
        this.setSupportedMediaTypes(SUPPORTED_MEDIA_TYPES);
    }

    public void setViewClass(Class<? extends ThymeleafReactiveView> viewClass) {
        if (viewClass == null || !ThymeleafReactiveView.class.isAssignableFrom(viewClass)) {
            throw new IllegalArgumentException("Given view class [" + (viewClass != null ? viewClass.getName() : null) + "] is not of type [" + ThymeleafReactiveView.class.getName() + "]");
        }
        this.viewClass = viewClass;
    }

    protected Class<? extends ThymeleafReactiveView> getViewClass() {
        return this.viewClass;
    }

    public ISpringWebFluxTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(ISpringWebFluxTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Map<String, Object> getStaticVariables() {
        return Collections.unmodifiableMap(this.staticVariables);
    }

    public void addStaticVariable(String name, Object value) {
        this.staticVariables.put(name, value);
    }

    public void setStaticVariables(Map<String, ?> variables) {
        if (variables != null) {
            for (Map.Entry<String, ?> entry : variables.entrySet()) {
                this.addStaticVariable(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setRedirectViewProvider(Function<String, RedirectView> redirectViewProvider) {
        Validate.notNull(redirectViewProvider, (String)"RedirectView provider cannot be null");
        this.redirectViewProvider = redirectViewProvider;
    }

    public Function<String, RedirectView> getRedirectViewProvider() {
        return this.redirectViewProvider;
    }

    public void setAlwaysProcessRedirectAndForward(boolean alwaysProcessRedirectAndForward) {
        this.alwaysProcessRedirectAndForward = alwaysProcessRedirectAndForward;
    }

    public boolean getAlwaysProcessRedirectAndForward() {
        return this.alwaysProcessRedirectAndForward;
    }

    public void setResponseMaxChunkSizeBytes(int responseMaxChunkSizeBytes) {
        this.responseMaxChunkSizeBytes = responseMaxChunkSizeBytes;
    }

    public int getResponseMaxChunkSizeBytes() {
        return this.responseMaxChunkSizeBytes;
    }

    public void setViewNames(String[] viewNames) {
        this.viewNames = viewNames;
    }

    public String[] getViewNames() {
        return this.viewNames;
    }

    public void setExcludedViewNames(String[] excludedViewNames) {
        this.excludedViewNames = excludedViewNames;
    }

    public String[] getExcludedViewNames() {
        return this.excludedViewNames;
    }

    protected boolean canHandle(String viewName, Locale locale) {
        String[] viewNamesToBeProcessed = this.getViewNames();
        String[] viewNamesNotToBeProcessed = this.getExcludedViewNames();
        return !(viewNamesToBeProcessed != null && !PatternMatchUtils.simpleMatch((String[])viewNamesToBeProcessed, (String)viewName) || viewNamesNotToBeProcessed != null && PatternMatchUtils.simpleMatch((String[])viewNamesNotToBeProcessed, (String)viewName));
    }

    public Mono<View> resolveViewName(String viewName, Locale locale) {
        if (!this.alwaysProcessRedirectAndForward && !this.canHandle(viewName, locale)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" cannot be handled by ThymeleafReactiveViewResolver. Passing on to the next resolver in the chain.", (Object)viewName);
            return Mono.empty();
        }
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" is a redirect, and will not be handled directly by ThymeleafReactiveViewResolver.", (Object)viewName);
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            RedirectView view = this.redirectViewProvider.apply(redirectUrl);
            RedirectView initializedView = (RedirectView)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
            return Mono.just((Object)initializedView);
        }
        if (viewName.startsWith(FORWARD_URL_PREFIX)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" is a forward, and will not be handled directly by ThymeleafReactiveViewResolver.", (Object)viewName);
            return Mono.error((Throwable)new UnsupportedOperationException("Forwards are not currently supported by ThymeleafReactiveViewResolver"));
        }
        if (this.alwaysProcessRedirectAndForward && !this.canHandle(viewName, locale)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" cannot be handled by ThymeleafReactiveViewResolver. Passing on to the next resolver in the chain.", (Object)viewName);
            return Mono.empty();
        }
        vrlogger.trace("[THYMELEAF] View {} will be handled by ThymeleafReactiveViewResolver and a {} instance will be created for it", (Object)viewName, (Object)this.getViewClass().getSimpleName());
        return this.loadView(viewName, locale);
    }

    protected Mono<View> loadView(String viewName, Locale locale) {
        ThymeleafReactiveView view;
        Class viewBeanType;
        AutowireCapableBeanFactory beanFactory = this.getApplicationContext().getAutowireCapableBeanFactory();
        boolean viewBeanExists = beanFactory.containsBean(viewName);
        Class clazz = viewBeanType = viewBeanExists ? beanFactory.getType(viewName) : null;
        if (viewBeanExists && viewBeanType != null && ThymeleafReactiveView.class.isAssignableFrom(viewBeanType)) {
            BeanDefinition viewBeanDefinition;
            BeanDefinition beanDefinition = viewBeanDefinition = beanFactory instanceof ConfigurableListableBeanFactory ? ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(viewName) : null;
            if (viewBeanDefinition == null || !viewBeanDefinition.isPrototype()) {
                ThymeleafReactiveView viewInstance = (ThymeleafReactiveView)((Object)BeanUtils.instantiateClass(this.getViewClass()));
                view = (ThymeleafReactiveView)((Object)beanFactory.configureBean((Object)viewInstance, viewName));
            } else {
                view = (ThymeleafReactiveView)((Object)beanFactory.getBean(viewName));
            }
        } else {
            ThymeleafReactiveView viewInstance = (ThymeleafReactiveView)((Object)BeanUtils.instantiateClass(this.getViewClass()));
            if (viewBeanExists && viewBeanType == null) {
                beanFactory.autowireBeanProperties((Object)viewInstance, 0, false);
                beanFactory.applyBeanPropertyValues((Object)viewInstance, viewName);
                view = (ThymeleafReactiveView)((Object)beanFactory.initializeBean((Object)viewInstance, viewName));
            } else {
                beanFactory.autowireBeanProperties((Object)viewInstance, 0, false);
                view = (ThymeleafReactiveView)((Object)beanFactory.initializeBean((Object)viewInstance, viewName));
            }
        }
        view.setTemplateEngine(this.getTemplateEngine());
        view.setStaticVariables(this.getStaticVariables());
        if (view.getTemplateName() == null) {
            view.setTemplateName(viewName);
        }
        if (!view.isSupportedMediaTypesSet()) {
            view.setSupportedMediaTypes(this.getSupportedMediaTypes());
        }
        if (!view.isDefaultCharsetSet()) {
            view.setDefaultCharset(this.getDefaultCharset());
        }
        if (locale != null && view.getLocale() == null) {
            view.setLocale(locale);
        }
        if (this.getResponseMaxChunkSizeBytes() != Integer.MAX_VALUE && view.getNullableResponseMaxChunkSize() == null) {
            view.setResponseMaxChunkSizeBytes(this.getResponseMaxChunkSizeBytes());
        }
        return Mono.just((Object)((Object)view));
    }
}

