/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.ValueFormatterWrapper;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.util.FieldUtils;
import org.thymeleaf.templatemode.TemplateMode;

public final class SpringUErrorsTagProcessor
extends AbstractAttributeTagProcessor {
    private static final String ERROR_DELIMITER = "<br />";
    public static final int ATTR_PRECEDENCE = 1700;
    public static final String ATTR_NAME = "uerrors";

    public SpringUErrorsTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, false, ATTR_NAME, true, 1700, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        BindStatus bindStatus = FieldUtils.getBindStatus((IExpressionContext)context, attributeValue);
        if (bindStatus.isError()) {
            StringBuilder strBuilder = new StringBuilder();
            String[] errorMsgs = bindStatus.getErrorMessages();
            for (int i = 0; i < errorMsgs.length; ++i) {
                if (i > 0) {
                    strBuilder.append(ERROR_DELIMITER);
                }
                String displayString = ValueFormatterWrapper.getDisplayString(errorMsgs[i], false);
                strBuilder.append(displayString);
            }
            structureHandler.setBody((CharSequence)strBuilder.toString(), false);
            structureHandler.setLocalVariable("springFieldBindStatus", (Object)bindStatus);
        } else {
            structureHandler.removeElement();
        }
    }
}

