/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import java.util.Map;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public final class SpringActionTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 1000;
    public static final String ATTR_NAME = "action";

    public SpringActionTagProcessor(IProcessorDialect dialect, String dialectPrefix) {
        super(dialect, TemplateMode.HTML, dialectPrefix, ATTR_NAME, 1000, false);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, String attributeTemplateName, int attributeLine, int attributeCol, Object expressionResult, IElementTagStructureHandler structureHandler) {
        Map<String, String> extraHiddenFields;
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? "" : expressionResult.toString()));
        String httpMethod = tag.getAttributes().getValue("method");
        newAttributeValue = RequestDataValueProcessorUtils.processAction(context, newAttributeValue, httpMethod);
        tag.getAttributes().replaceAttribute(attributeName, ATTR_NAME, newAttributeValue == null ? "" : newAttributeValue);
        if ("form".equalsIgnoreCase(tag.getElementName()) && (extraHiddenFields = RequestDataValueProcessorUtils.getExtraHiddenFields(context)) != null && extraHiddenFields.size() > 0) {
            IModelFactory modelFactory = context.getConfiguration().getModelFactory(context.getTemplateMode());
            IModel extraHiddenElementTags = modelFactory.createModel();
            for (Map.Entry<String, String> extraHiddenField : extraHiddenFields.entrySet()) {
                IStandaloneElementTag extraHiddenElementTag = modelFactory.createStandaloneElementTag("input", true);
                extraHiddenElementTag.getAttributes().setAttribute("type", "hidden");
                extraHiddenElementTag.getAttributes().setAttribute("name", extraHiddenField.getKey());
                extraHiddenElementTag.getAttributes().setAttribute("value", extraHiddenField.getValue());
                extraHiddenElementTags.add((ITemplateEvent)extraHiddenElementTag);
            }
            structureHandler.insertImmediatelyAfter(extraHiddenElementTags, false);
        }
    }
}

