/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import java.util.Locale;
import org.springframework.ui.context.Theme;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;

public class Themes {
    private final Theme theme;
    private final Locale locale;

    public Themes(IProcessingContext processingContext) {
        this.locale = processingContext.getLocale();
        RequestContext requestContext = (RequestContext)processingContext.getVariables().getVariable("springRequestContext");
        this.theme = requestContext != null ? requestContext.getTheme() : null;
    }

    public String code(String code) {
        if (this.theme == null) {
            throw new TemplateProcessingException("Theme cannot be resolved because RequestContext was not found. Are you using a Context object without a RequestContext variable?");
        }
        return this.theme.getMessageSource().getMessage(code, null, "", this.locale);
    }
}

