/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IVariablesMap;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring4.expression.SPELVariablesMapPropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SPELVariablesMapWrapper
implements Map {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPELVariablesMapWrapper.class);
    private static final String REQUEST_PARAMETERS_RESTRICTED_VARIABLE_NAME = "param";
    private final IVariablesMap variablesMap;
    private final IThymeleafEvaluationContext evaluationContext;

    SPELVariablesMapWrapper(IVariablesMap variablesMap, IThymeleafEvaluationContext evaluationContext) {
        this.variablesMap = variablesMap;
        this.evaluationContext = evaluationContext;
    }

    @Override
    public int size() {
        throw new TemplateProcessingException("Cannot call #size() on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    @Override
    public boolean isEmpty() {
        throw new TemplateProcessingException("Cannot call #isEmpty() on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.evaluationContext.isVariableAccessRestricted() && REQUEST_PARAMETERS_RESTRICTED_VARIABLE_NAME.equals(key)) {
            throw new TemplateProcessingException("Access to variable \"" + key + "\" is forbidden in this context. Note some restrictions apply to " + "variable access. For example, accessing request parameters is forbidden in preprocessing and " + "unescaped expressions, and also in fragment inclusion specifications.");
        }
        return this.variablesMap != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new TemplateProcessingException("Cannot call #containsValue(value) on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    public Object get(Object key) {
        Object execInfoResult;
        if (this.variablesMap == null) {
            throw new TemplateProcessingException("Cannot read property on null target");
        }
        if ("execInfo".equals(key) && (execInfoResult = SPELVariablesMapPropertyAccessor.checkExecInfo(key.toString(), this.evaluationContext)) != null) {
            return execInfoResult;
        }
        return this.variablesMap.getVariable(key == null ? null : key.toString());
    }

    public Object put(Object key, Object value) {
        throw new TemplateProcessingException("Cannot call #put(key,value) on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    public Object remove(Object key) {
        throw new TemplateProcessingException("Cannot call #remove(key) on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    public void putAll(Map m) {
        throw new TemplateProcessingException("Cannot call #putAll(m) on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    @Override
    public void clear() {
        throw new TemplateProcessingException("Cannot call #clear() on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    public Set keySet() {
        throw new TemplateProcessingException("Cannot call #keySet() on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    public Collection values() {
        throw new TemplateProcessingException("Cannot call #values() on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }

    public Set<Map.Entry> entrySet() {
        throw new TemplateProcessingException("Cannot call #entrySet() on an " + IVariablesMap.class.getSimpleName() + " implementation");
    }
}

