/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.requestdata;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebVariablesMap;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.requestdata.IRequestDataValueProcessorDelegate;
import org.thymeleaf.spring4.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestDataValueProcessorUtils {
    private static final boolean canApply;
    private static final boolean isSpring31AtLeast;
    private static final boolean isSpring40AtLeast;
    private static final String SPRING4_DELEGATE_CLASS = "org.thymeleaf.spring4.requestdata.RequestDataValueProcessor4Delegate";
    private static final IRequestDataValueProcessorDelegate spring4Delegate;
    private static final Logger LOGGER;

    public static String processAction(IProcessingContext processingContext, String action, String httpMethod) {
        if (!canApply || !processingContext.isWeb()) {
            return action;
        }
        IWebVariablesMap variablesMap = (IWebVariablesMap)processingContext.getVariables();
        RequestContext requestContext = (RequestContext)variablesMap.getVariable("springRequestContext");
        if (requestContext == null) {
            return action;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.processAction(requestContext, variablesMap.getRequest(), action, httpMethod);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static String processFormFieldValue(IProcessingContext processingContext, String name, String value, String type) {
        if (!canApply || !processingContext.isWeb()) {
            return value;
        }
        IWebVariablesMap variablesMap = (IWebVariablesMap)processingContext.getVariables();
        RequestContext requestContext = (RequestContext)variablesMap.getVariable("springRequestContext");
        if (requestContext == null) {
            return value;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.processFormFieldValue(requestContext, variablesMap.getRequest(), name, value, type);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static Map<String, String> getExtraHiddenFields(IProcessingContext processingContext) {
        if (!canApply || !processingContext.isWeb()) {
            return null;
        }
        IWebVariablesMap variablesMap = (IWebVariablesMap)processingContext.getVariables();
        RequestContext requestContext = (RequestContext)variablesMap.getVariable("springRequestContext");
        if (requestContext == null) {
            return null;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.getExtraHiddenFields(requestContext, variablesMap.getRequest());
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static String processUrl(IProcessingContext processingContext, String url) {
        if (!canApply || !processingContext.isWeb()) {
            return url;
        }
        IWebVariablesMap variablesMap = (IWebVariablesMap)processingContext.getVariables();
        RequestContext requestContext = (RequestContext)variablesMap.getVariable("springRequestContext");
        if (requestContext == null) {
            return url;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.processUrl(requestContext, variablesMap.getRequest(), url);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    private RequestDataValueProcessorUtils() {
    }

    static {
        LOGGER = LoggerFactory.getLogger(RequestDataValueProcessorUtils.class);
        isSpring31AtLeast = SpringVersionUtils.isSpring31AtLeast();
        canApply = isSpring40AtLeast = SpringVersionUtils.isSpring40AtLeast();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(RequestDataValueProcessorUtils.class);
        if (isSpring40AtLeast) {
            try {
                Class<?> implClass = Class.forName(SPRING4_DELEGATE_CLASS, true, classLoader);
                spring4Delegate = (IRequestDataValueProcessorDelegate)implClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Environment has been detected to be at least Spring 4, but thymeleaf could not initialize a delegate of class \"org.thymeleaf.spring4.requestdata.RequestDataValueProcessor4Delegate\"", (Throwable)e);
            }
        } else {
            LOGGER.warn("[THYMELEAF] You seem to be using the thymeleaf-spring4 module with Spring version 3.x. Even though most features should work OK, support for CSRF protection on websites will be disabled due to incompatibilities between the different versions of the RequestDataValueProcessor interface in versions 4.x and 3.x.");
            spring4Delegate = null;
        }
    }
}

