/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.spring4.util.FieldUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;

public abstract class AbstractSpringFieldTagProcessor
extends AbstractAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 1200;
    public static final String ATTR_NAME = "field";
    protected static final String INPUT_TAG_NAME = "input";
    protected static final String SELECT_TAG_NAME = "select";
    protected static final String OPTION_TAG_NAME = "option";
    protected static final String TEXTAREA_TAG_NAME = "textarea";
    protected static final String INPUT_TYPE_ATTR_NAME = "type";
    private final String discriminatorAttrName;
    private final String[] discriminatorAttrValues;

    public AbstractSpringFieldTagProcessor(String dialectPrefix, String elementName, String discriminatorAttrName, String[] discriminatorAttrValues) {
        super(TemplateMode.HTML, dialectPrefix, elementName, false, ATTR_NAME, true, 1200);
        this.discriminatorAttrName = discriminatorAttrName;
        this.discriminatorAttrValues = discriminatorAttrValues;
    }

    private boolean matchesDiscriminator(IProcessableElementTag tag) {
        if (this.discriminatorAttrName == null) {
            return true;
        }
        boolean hasDiscriminatorAttr = tag.getAttributes().hasAttribute(this.discriminatorAttrName);
        if (this.discriminatorAttrValues == null || this.discriminatorAttrValues.length == 0) {
            return hasDiscriminatorAttr;
        }
        String discriminatorTagValue = hasDiscriminatorAttr ? tag.getAttributes().getValue(this.discriminatorAttrName) : null;
        for (int i = 0; i < this.discriminatorAttrValues.length; ++i) {
            String discriminatorAttrValue = this.discriminatorAttrValues[i];
            if (!(discriminatorAttrValue == null ? !hasDiscriminatorAttr || discriminatorTagValue == null : discriminatorAttrValue.equals(discriminatorTagValue))) continue;
            return true;
        }
        return false;
    }

    protected void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementStructureHandler structureHandler) {
        if (!this.matchesDiscriminator(tag)) {
            return;
        }
        BindStatus bindStatus = FieldUtils.getBindStatus((IProcessingContext)processingContext, attributeValue);
        structureHandler.setLocalVariable("springFieldBindStatus", (Object)bindStatus);
        this.doProcess(processingContext, tag, attributeName, attributeValue, bindStatus, structureHandler);
    }

    protected abstract void doProcess(ITemplateProcessingContext var1, IProcessableElementTag var2, AttributeName var3, String var4, BindStatus var5, IElementStructureHandler var6);

    protected final String computeId(ITemplateProcessingContext processingContext, IProcessableElementTag tag, String name, boolean sequence) {
        String id = tag.getAttributes().getValue("id");
        if (!StringUtils.isEmptyOrWhitespace((String)id)) {
            return org.springframework.util.StringUtils.hasText((String)id) ? id : null;
        }
        id = FieldUtils.idFromName(name);
        if (sequence) {
            Integer count = processingContext.getIdentifierSequences().getAndIncrementIDSeq(id);
            return id + count.toString();
        }
        return id;
    }
}

