/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.util;

import org.thymeleaf.util.Validate;

public final class DetailedError {
    private static final String GLOBAL_FIELD_NAME = "[global]";
    private final String fieldName;
    private final String code;
    private final Object[] arguments;
    private final String message;

    public DetailedError(String code, Object[] arguments, String message) {
        this(GLOBAL_FIELD_NAME, code, arguments, message);
    }

    public DetailedError(String fieldName, String code, Object[] arguments, String message) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Validate.notNull((Object)code, (String)"Code cannot be null");
        Validate.notNull((Object)message, (String)"Message cannot be null");
        this.fieldName = fieldName;
        this.code = code;
        this.arguments = arguments;
        this.message = message;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isGlobal() {
        return GLOBAL_FIELD_NAME.equalsIgnoreCase(this.fieldName);
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.fieldName);
        strBuilder.append(":");
        strBuilder.append(this.message);
        return strBuilder.toString();
    }
}

