/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.view;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.fragment.ChainedFragmentSpec;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.context.SpringWebContext;
import org.thymeleaf.spring4.view.AbstractThymeleafView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafView
extends AbstractThymeleafView {
    private static final String pathVariablesSelector;
    private IFragmentSpec fragmentSpec = null;

    protected ThymeleafView() {
    }

    protected ThymeleafView(String templateName) {
        super(templateName);
    }

    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    public void setFragmentSpec(IFragmentSpec fragmentSpec) {
        this.fragmentSpec = fragmentSpec;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.renderFragment(null, model, request, response);
    }

    protected void renderFragment(IFragmentSpec fragmentSpecToRender, Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map pathVars;
        ServletContext servletContext = this.getServletContext();
        if (this.getTemplateName() == null) {
            throw new IllegalArgumentException("Property 'templateName' is required");
        }
        if (this.getLocale() == null) {
            throw new IllegalArgumentException("Property 'locale' is required");
        }
        if (this.getTemplateEngine() == null) {
            throw new IllegalArgumentException("Property 'templateEngine' is required");
        }
        HashMap<String, Object> mergedModel = new HashMap<String, Object>(30);
        Map<String, Object> templateStaticVariables = this.getStaticVariables();
        if (templateStaticVariables != null) {
            mergedModel.putAll(templateStaticVariables);
        }
        if (pathVariablesSelector != null && (pathVars = (Map)request.getAttribute(pathVariablesSelector)) != null) {
            mergedModel.putAll(pathVars);
        }
        if (model != null) {
            mergedModel.putAll(model);
        }
        RequestContext requestContext = new RequestContext(request, response, this.getServletContext(), mergedModel);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springRequestContext", requestContext);
        ThymeleafView.addRequestContextAsVariable(mergedModel, "springMacroRequestContext", requestContext);
        SpringWebContext context = new SpringWebContext(request, response, servletContext, this.getLocale(), mergedModel, this.getApplicationContext());
        SpringTemplateEngine viewTemplateEngine = this.getTemplateEngine();
        String templateContentType = this.getContentType();
        Locale templateLocale = this.getLocale();
        String templateCharacterEncoding = this.getCharacterEncoding();
        Object templateFragmentSpec = null;
        IFragmentSpec viewFragmentSpec = this.getFragmentSpec();
        templateFragmentSpec = viewFragmentSpec == null ? fragmentSpecToRender : (fragmentSpecToRender == null ? viewFragmentSpec : new ChainedFragmentSpec(viewFragmentSpec, fragmentSpecToRender));
        response.setLocale(templateLocale);
        if (templateContentType != null) {
            response.setContentType(templateContentType);
        } else {
            response.setContentType("text/html;charset=ISO-8859-1");
        }
        if (templateCharacterEncoding != null) {
            response.setCharacterEncoding(templateCharacterEncoding);
        }
        viewTemplateEngine.process(this.getTemplateName(), (IContext)context, (IFragmentSpec)templateFragmentSpec, response.getWriter());
    }

    static {
        String pathVariablesSelectorValue = null;
        try {
            Field pathVariablesField = View.class.getDeclaredField("PATH_VARIABLES");
            pathVariablesSelectorValue = (String)pathVariablesField.get(null);
        }
        catch (NoSuchFieldException ignored) {
            pathVariablesSelectorValue = null;
        }
        catch (IllegalAccessException ignored) {
            pathVariablesSelectorValue = null;
        }
        pathVariablesSelector = pathVariablesSelectorValue;
    }
}

