/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.expression.Fields;
import org.thymeleaf.spring4.expression.SpelEvaluationContext;
import org.thymeleaf.spring4.expression.Themes;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardVariableRestrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpelVariableExpressionEvaluator
implements IStandardVariableExpressionEvaluator {
    public static final SpelVariableExpressionEvaluator INSTANCE = new SpelVariableExpressionEvaluator();
    private static final String SPEL_CACHE_PREFIX = "{spel}";
    public static final String FIELDS_EVALUATION_VARIABLE_NAME = "fields";
    public static final String THEMES_EVALUATION_VARIABLE_NAME = "themes";
    private static final Logger logger = LoggerFactory.getLogger(SpelVariableExpressionEvaluator.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    static final StandardEvaluationContext DEFAULT_EVALUATION_CONTEXT = new StandardEvaluationContext();

    protected SpelVariableExpressionEvaluator() {
    }

    public final Object evaluate(Configuration configuration, IProcessingContext processingContext, String spelExpression, StandardExpressionExecutionContext expContext, boolean useSelectionAsRoot) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] SpringEL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)spelExpression);
        }
        try {
            Map<String, Object> contextVariables = this.computeExpressionObjects(configuration, processingContext);
            SpelEvaluationContext evaluationContext = new SpelEvaluationContext((EvaluationContext)DEFAULT_EVALUATION_CONTEXT, contextVariables);
            SpelExpression exp = SpelVariableExpressionEvaluator.getExpression(configuration, spelExpression);
            Object evaluationRoot = useSelectionAsRoot ? processingContext.getExpressionSelectionEvaluationRoot() : processingContext.getExpressionEvaluationRoot();
            this.setVariableRestrictions(expContext, evaluationRoot, contextVariables);
            return exp.getValue((EvaluationContext)evaluationContext, evaluationRoot);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception evaluating SpringEL expression: \"" + spelExpression + "\"", (Throwable)e);
        }
    }

    private static SpelExpression getExpression(Configuration configuration, String spelExpression) {
        SpelExpression exp = null;
        ICache cache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            exp = (SpelExpression)cache.get((Object)(SPEL_CACHE_PREFIX + spelExpression));
        }
        if (exp == null) {
            exp = (SpelExpression)PARSER.parseExpression(spelExpression);
            if (cache != null && null != exp) {
                cache.put((Object)(SPEL_CACHE_PREFIX + spelExpression), (Object)exp);
            }
        }
        return exp;
    }

    @Deprecated
    public Map<String, Object> computeContextVariables(Configuration configuration, IProcessingContext processingContext) {
        return this.computeExpressionObjects(configuration, processingContext);
    }

    public Map<String, Object> computeExpressionObjects(Configuration configuration, IProcessingContext processingContext) {
        Map<String, Object> additionalExpressionObjects;
        Map expressionObjects = processingContext.getExpressionObjects();
        Fields fields = new Fields(configuration, processingContext);
        expressionObjects.put(FIELDS_EVALUATION_VARIABLE_NAME, fields);
        if (processingContext.getContext() instanceof IWebContext) {
            VariablesMap variables = processingContext.getContext().getVariables();
            if (!variables.containsKey((Object)THEMES_EVALUATION_VARIABLE_NAME)) {
                variables.put((Object)THEMES_EVALUATION_VARIABLE_NAME, (Object)new Themes(processingContext));
            }
            expressionObjects.put(THEMES_EVALUATION_VARIABLE_NAME, variables.get((Object)THEMES_EVALUATION_VARIABLE_NAME));
        }
        if ((additionalExpressionObjects = this.computeAdditionalExpressionObjects(processingContext)) != null) {
            expressionObjects.putAll(additionalExpressionObjects);
        }
        return expressionObjects;
    }

    protected Map<String, Object> computeAdditionalExpressionObjects(IProcessingContext processingContext) {
        return null;
    }

    protected void setVariableRestrictions(StandardExpressionExecutionContext expContext, Object evaluationRoot, Map<String, Object> contextVariables) {
        List restrictions = expContext.getForbidRequestParameters() ? StandardVariableRestrictions.REQUEST_PARAMETERS_FORBIDDEN : null;
        Object context = contextVariables.get("ctx");
        if (context != null && context instanceof IContext) {
            VariablesMap variablesMap = ((IContext)context).getVariables();
            variablesMap.setRestrictions(restrictions);
        }
        if (evaluationRoot != null && evaluationRoot instanceof VariablesMap) {
            ((VariablesMap)evaluationRoot).setRestrictions(restrictions);
        }
    }

    public String toString() {
        return "SpringEL";
    }
}

