/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICache;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.expression.BeansPropertyAccessor;
import org.thymeleaf.spring4.expression.Fields;
import org.thymeleaf.spring4.expression.SpelEvaluationContext;
import org.thymeleaf.spring4.expression.VariablesMapPropertyAccessor;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SpelExpressionEvaluator
implements IStandardExpressionEvaluator {
    public static final SpelExpressionEvaluator INSTANCE = new SpelExpressionEvaluator();
    private static final String SPEL_CACHE_PREFIX = "{spel}";
    public static final String FIELDS_EVALUATION_VARIABLE_NAME = "fields";
    public static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();
    private static final Logger logger = LoggerFactory.getLogger(SpelExpressionEvaluator.class);
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final StandardEvaluationContext DEFAULT_EVALUATION_CONTEXT = new StandardEvaluationContext();

    private SpelExpressionEvaluator() {
    }

    public final Object evaluate(Arguments arguments, String spelExpression, Object root) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] SpringEL expression: evaluating expression \"{}\" on target", (Object)TemplateEngine.threadIndex(), (Object)spelExpression);
        }
        try {
            HashMap<String, Object> contextVariables = new HashMap<String, Object>();
            Map expressionObjects = arguments.getExpressionObjects();
            if (expressionObjects != null) {
                contextVariables.putAll(expressionObjects);
            }
            Fields fields = new Fields(arguments);
            contextVariables.put(FIELDS_EVALUATION_VARIABLE_NAME, fields);
            Map<String, Object> additionalContextVariables = this.computeAdditionalContextVariables(arguments);
            if (additionalContextVariables != null && !additionalContextVariables.isEmpty()) {
                contextVariables.putAll(additionalContextVariables);
            }
            SpelEvaluationContext context = new SpelEvaluationContext((EvaluationContext)DEFAULT_EVALUATION_CONTEXT, contextVariables);
            SpelExpression exp = SpelExpressionEvaluator.getExpression(arguments.getConfiguration(), spelExpression);
            return exp.getValue((EvaluationContext)context, root);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Exception evaluating SpringEL expression: \"" + spelExpression + "\"", (Throwable)e);
        }
    }

    private static SpelExpression getExpression(Configuration configuration, String spelExpression) {
        SpelExpression exp = null;
        ICache cache = null;
        ICacheManager cacheManager = configuration.getCacheManager();
        if (cacheManager != null && (cache = cacheManager.getExpressionCache()) != null) {
            exp = (SpelExpression)cache.get((Object)(SPEL_CACHE_PREFIX + spelExpression));
        }
        if (exp == null) {
            exp = (SpelExpression)PARSER.parseExpression(spelExpression);
            if (cache != null && null != exp) {
                cache.put((Object)(SPEL_CACHE_PREFIX + spelExpression), (Object)exp);
            }
        }
        return exp;
    }

    protected Map<String, Object> computeAdditionalContextVariables(Arguments arguments) {
        return Collections.emptyMap();
    }

    public String toString() {
        return "SpringEL";
    }

    static {
        DEFAULT_EVALUATION_CONTEXT.addPropertyAccessor((PropertyAccessor)VariablesMapPropertyAccessor.INSTANCE);
        DEFAULT_EVALUATION_CONTEXT.addPropertyAccessor((PropertyAccessor)BeansPropertyAccessor.INSTANCE);
        DEFAULT_EVALUATION_CONTEXT.addPropertyAccessor((PropertyAccessor)MAP_ACCESSOR_INSTANCE);
    }
}

