/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.standard.processor.attr.AbstractStandardSelectionAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringObjectAttrProcessor
extends AbstractStandardSelectionAttrProcessor {
    public static final int ATTR_PRECEDENCE = 500;
    public static final String ATTR_NAME = "object";

    public SpringObjectAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 500;
    }

    protected void validateSelectionValue(Arguments arguments, Element element, String attributeName, String attributeValue, Expression expression) {
        if ("form".equals(element.getNormalizedName())) {
            if (expression != null && expression instanceof VariableExpression) {
                String varExp = ((VariableExpression)expression).getExpression();
                if (varExp.indexOf(46) >= 0 || varExp.indexOf(91) >= 0 || varExp.indexOf(93) >= 0) {
                    throw new TemplateProcessingException("The expression used as a form model is " + expression + ", which is not allowed by " + "Spring MVC. Target selection expressions used for forms in Spring have to be " + "just context variable names. Nested calls (like \"user.name\") and " + "indexed accesses (like \"user['name']\") are forbidden.");
                }
                return;
            }
            throw new TemplateProcessingException("The expression used as a form model is " + expression + ", which is not valid: " + "only variable expressions are allowed as Spring " + "MVC form model objects.");
        }
        VariableExpression formCommandValue = (VariableExpression)arguments.getLocalVariable("springFormCommandValue");
        if (formCommandValue != null) {
            throw new TemplateProcessingException("A selection expression " + expression + " has been specified inside a Spring MVC " + "form, but this is not allowed. Selection expressions cannot be nested inside forms.");
        }
    }

    protected Map<String, Object> getAdditionalLocalVariables(Arguments arguments, Element element, String attributeName) {
        HashMap<String, Object> additionalLocalVariables = new HashMap<String, Object>();
        additionalLocalVariables.putAll(super.getAdditionalLocalVariables(arguments, element, attributeName));
        if ("form".equals(element.getNormalizedName())) {
            String attributeValue = element.getAttributeValue(attributeName);
            VariableExpression varExpression = (VariableExpression)StandardExpressionProcessor.parseExpression((Arguments)arguments, (String)attributeValue);
            additionalLocalVariables.put("springFormCommandValue", varExpression);
        }
        return additionalLocalVariables;
    }
}

