/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import java.util.Map;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.spring4.processor.attr.AbstractSpringFieldAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringInputCheckboxFieldAttrProcessor
extends AbstractSpringFieldAttrProcessor {
    public static final String CHECKBOX_INPUT_TYPE_ATTR_VALUE = "checkbox";

    public SpringInputCheckboxFieldAttrProcessor() {
        super("field", "input", "type", CHECKBOX_INPUT_TYPE_ATTR_VALUE);
    }

    @Override
    protected ProcessorResult doProcess(Arguments arguments, Element element, String attributeName, String attributeValue, BindStatus bindStatus, Map<String, Object> localVariables) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(arguments, element, name, true);
        String value = null;
        boolean checked = false;
        Object boundValue = bindStatus.getValue();
        Class valueType = bindStatus.getValueType();
        if (Boolean.class.equals((Object)valueType) || Boolean.TYPE.equals(valueType)) {
            if (boundValue instanceof String) {
                boundValue = Boolean.valueOf((String)boundValue);
            }
            Boolean booleanValue = boundValue != null ? (Boolean)boundValue : Boolean.FALSE;
            value = "true";
            checked = booleanValue;
        } else {
            value = element.getAttributeValue("value");
            if (value == null) {
                throw new TemplateProcessingException("Attribute \"value\" is required in \"input(checkbox)\" tags when binding to non-boolean values");
            }
            checked = SelectedValueComparatorWrapper.isSelected(bindStatus, value);
        }
        NestableNode parent = element.getParent();
        Element inputElement = (Element)element.cloneNode(parent, false);
        inputElement.removeAttribute(attributeName);
        inputElement.setAttribute("id", id);
        inputElement.setAttribute("name", name);
        inputElement.setAttribute("value", value);
        if (checked) {
            inputElement.setAttribute("checked", "checked");
        } else {
            inputElement.removeAttribute("checked");
        }
        inputElement.setAllNodeLocalVariables(localVariables);
        parent.insertBefore((Node)element, (Node)inputElement);
        if (!SpringInputCheckboxFieldAttrProcessor.isDisabled(inputElement)) {
            Element hiddenElement = new Element("input");
            hiddenElement.setAttribute("type", "hidden");
            hiddenElement.setAttribute("name", "_" + name);
            hiddenElement.setAttribute("value", "on");
            hiddenElement.setAllNodeLocalVariables(localVariables);
            parent.insertBefore((Node)element, (Node)hiddenElement);
        }
        parent.removeChild((Node)element);
        return ProcessorResult.OK;
    }

    private static final boolean isDisabled(Element inputElement) {
        return inputElement.hasNormalizedAttribute("disabled");
    }
}

