/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor.attr;

import java.util.List;
import java.util.Map;
import org.springframework.web.servlet.support.BindStatus;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.spring3.processor.attr.AbstractSpringFieldAttrProcessor;
import org.thymeleaf.spring3.requestdata.RequestDataValueProcessorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringSelectFieldAttrProcessor
extends AbstractSpringFieldAttrProcessor {
    public SpringSelectFieldAttrProcessor() {
        super("field", "select");
    }

    @Override
    protected ProcessorResult doProcess(Arguments arguments, Element element, String attributeName, String attributeValue, BindStatus bindStatus, Map<String, Object> localVariables) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(arguments, element, name, false);
        boolean multiple = element.hasAttribute("multiple");
        NestableNode parent = element.getParent();
        Element inputElement = (Element)element.cloneNode(parent, false);
        inputElement.removeAttribute(attributeName);
        inputElement.setAttribute("id", id);
        inputElement.setAttribute("name", name);
        inputElement.setAllNodeLocalVariables(localVariables);
        this.processOptionChildren(inputElement, attributeName, attributeValue);
        parent.insertBefore((Node)element, (Node)inputElement);
        parent.removeChild((Node)element);
        if (multiple && !SpringSelectFieldAttrProcessor.isDisabled(inputElement)) {
            String hiddenName = "_" + name;
            Element hiddenElement = new Element("input");
            hiddenElement.setAttribute("type", "hidden");
            hiddenElement.setAttribute("name", hiddenName);
            hiddenElement.setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue(arguments.getConfiguration(), (IProcessingContext)arguments, hiddenName, "1", "hidden"));
            hiddenElement.setAllNodeLocalVariables(localVariables);
            parent.insertAfter((Node)inputElement, (Node)hiddenElement);
        }
        return ProcessorResult.OK;
    }

    private void processOptionChildren(Element inputTag, String selectAttrName, String selectAttrValue) {
        List children = inputTag.getChildren();
        for (Node child : children) {
            if (child == null || !(child instanceof Element)) continue;
            Element childTag = (Element)child;
            String childTagName = childTag.getNormalizedName();
            childTag.setProcessable(true);
            if ("option".equals(childTagName)) {
                if (childTag.hasAttribute(selectAttrName)) {
                    String selectAttrInChildValue = childTag.getAttributeValue(selectAttrName);
                    if (selectAttrInChildValue == null || selectAttrValue.equals(selectAttrInChildValue)) continue;
                    throw new TemplateProcessingException("If specified (which is not required), attribute \"" + selectAttrName + "\" in \"option\" tag must have " + "exactly the same value as in its containing \"select\" " + "tag");
                }
                childTag.setAttribute(selectAttrName, selectAttrValue);
                childTag.setRecomputeProcessorsImmediately(true);
                continue;
            }
            if (!"optgroup".equals(childTagName)) continue;
            this.processOptionChildren(childTag, selectAttrName, selectAttrValue);
        }
    }

    private static final boolean isDisabled(Element inputElement) {
        return inputElement.hasNormalizedAttribute("disabled");
    }
}

