/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor.attr;

import java.util.Map;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.spring3.processor.attr.AbstractSpringFieldAttrProcessor;
import org.thymeleaf.spring3.requestdata.RequestDataValueProcessorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringInputRadioFieldAttrProcessor
extends AbstractSpringFieldAttrProcessor {
    public static final String RADIO_INPUT_TYPE_ATTR_VALUE = "radio";

    public SpringInputRadioFieldAttrProcessor() {
        super("field", "input", "type", RADIO_INPUT_TYPE_ATTR_VALUE);
    }

    @Override
    protected ProcessorResult doProcess(Arguments arguments, Element element, String attributeName, String attributeValue, BindStatus bindStatus, Map<String, Object> localVariables) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(arguments, element, name, true);
        String value = element.getAttributeValue("value");
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"input(radio)\" tags");
        }
        boolean checked = SelectedValueComparatorWrapper.isSelected(bindStatus, value);
        element.setAttribute("id", id);
        element.setAttribute("name", name);
        element.setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue(arguments.getConfiguration(), (IProcessingContext)arguments, name, value, RADIO_INPUT_TYPE_ATTR_VALUE));
        if (checked) {
            element.setAttribute("checked", "checked");
        } else {
            element.removeAttribute("checked");
        }
        element.removeAttribute(attributeName);
        return ProcessorResult.setLocalVariables(localVariables);
    }
}

