/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity4.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.WebAttributes;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.extras.springsecurity4.auth.SpringVersionSpecificUtils;
import org.thymeleaf.extras.springsecurity4.util.SpringSecurityWebApplicationContextUtils;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtils.class);
    private static final FilterChain DUMMY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }
    };

    private AuthUtils() {
    }

    public static Authentication getAuthenticationObject() {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Obtaining authentication object.", new Object[]{TemplateEngine.threadIndex()});
        }
        if (SecurityContextHolder.getContext() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] No security context found, no authentication object returned.", new Object[]{TemplateEngine.threadIndex()});
            }
            return null;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication.getPrincipal() == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] No authentication object found in context.", new Object[]{TemplateEngine.threadIndex()});
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Authentication object of class {} found in context for user \"{}\".", new Object[]{TemplateEngine.threadIndex(), authentication.getClass().getName(), authentication.getName()});
        }
        return authentication;
    }

    public static Object getAuthenticationProperty(Authentication authentication, String property) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Reading property \"{}\" from authentication object.", new Object[]{TemplateEngine.threadIndex(), property});
        }
        if (authentication == null) {
            return null;
        }
        try {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)authentication);
            Object propertyObj = wrapper.getPropertyValue(property);
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Property \"{}\" obtained from authentication object for user \"{}\". Returned value of class {}.", new Object[]{TemplateEngine.threadIndex(), property, authentication.getName(), propertyObj == null ? null : propertyObj.getClass().getName()});
            }
            return propertyObj;
        }
        catch (BeansException e) {
            throw new TemplateProcessingException("Error retrieving value for property \"" + property + "\" of authentication object of class " + authentication.getClass().getName(), (Throwable)e);
        }
    }

    public static boolean authorizeUsingAccessExpression(IProcessingContext processingContext, String accessExpression, Authentication authentication, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        EvaluationContext wrappedEvaluationContext;
        Validate.notNull((Object)processingContext, (String)"Processing context cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checking authorization using access expression \"{}\" for user \"{}\".", new Object[]{TemplateEngine.threadIndex(), accessExpression, authentication == null ? null : authentication.getName()});
        }
        String expr = accessExpression != null && accessExpression.startsWith("${") && accessExpression.endsWith("}") ? accessExpression.substring(2, accessExpression.length() - 1) : accessExpression;
        SecurityExpressionHandler<FilterInvocation> handler = AuthUtils.getExpressionHandler(servletContext);
        Expression expressionObject = null;
        try {
            expressionObject = handler.getExpressionParser().parseExpression(expr);
        }
        catch (ParseException e) {
            throw new TemplateProcessingException("An error happened trying to parse Spring Security access expression \"" + expr + "\"", (Throwable)e);
        }
        FilterInvocation filterInvocation = new FilterInvocation((ServletRequest)request, (ServletResponse)response, DUMMY_CHAIN);
        EvaluationContext evaluationContext = handler.createEvaluationContext(authentication, (Object)filterInvocation);
        Map<Object, Object> contextVariables = null;
        if (processingContext instanceof Arguments) {
            Arguments arguments = (Arguments)processingContext;
            IStandardVariableExpressionEvaluator expressionEvaluator = StandardExpressions.getVariableExpressionEvaluator((Configuration)arguments.getConfiguration());
            contextVariables = SpringVersionSpecificUtils.computeExpressionObjectsFromExpressionEvaluator(arguments, expressionEvaluator);
        }
        if (contextVariables == null) {
            contextVariables = new HashMap();
            Map expressionObjects = processingContext.getExpressionObjects();
            if (expressionObjects != null) {
                contextVariables.putAll(expressionObjects);
            }
        }
        if (ExpressionUtils.evaluateAsBoolean((Expression)expressionObject, (EvaluationContext)(wrappedEvaluationContext = SpringVersionSpecificUtils.wrapEvaluationContext(evaluationContext, contextVariables)))) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Checked authorization using access expression \"{}\" for user \"{}\". Access GRANTED.", new Object[]{TemplateEngine.threadIndex(), accessExpression, authentication == null ? null : authentication.getName()});
            }
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checked authorization using access expression \"{}\" for user \"{}\". Access DENIED.", new Object[]{TemplateEngine.threadIndex(), accessExpression, authentication == null ? null : authentication.getName()});
        }
        return false;
    }

    private static SecurityExpressionHandler<FilterInvocation> getExpressionHandler(ServletContext servletContext) {
        ApplicationContext ctx = AuthUtils.getContext(servletContext);
        Map expressionHandlers = ctx.getBeansOfType(SecurityExpressionHandler.class);
        for (SecurityExpressionHandler handler : expressionHandlers.values()) {
            if (!FilterInvocation.class.equals((Object)GenericTypeResolver.resolveTypeArgument(handler.getClass(), SecurityExpressionHandler.class))) continue;
            return handler;
        }
        throw new TemplateProcessingException("No visible SecurityExpressionHandler instance could be found in the application context. There must be at least one in order to support expressions in Spring Security authorization queries.");
    }

    public static boolean authorizeUsingUrlCheck(String url, String method, Authentication authentication, HttpServletRequest request, ServletContext servletContext) {
        boolean result;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checking authorization for URL \"{}\" and method \"{}\" for user \"{}\".", new Object[]{TemplateEngine.threadIndex(), url, method, authentication == null ? null : authentication.getName()});
        }
        boolean bl = result = AuthUtils.getPrivilegeEvaluator(servletContext, request).isAllowed(request.getContextPath(), url, method, authentication);
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Checked authorization for URL \"{}\" and method \"{}\" for user \"{}\". " + (result ? "Access GRANTED." : "Access DENIED."), new Object[]{TemplateEngine.threadIndex(), url, method, authentication == null ? null : authentication.getName()});
        }
        return result;
    }

    private static WebInvocationPrivilegeEvaluator getPrivilegeEvaluator(ServletContext servletContext, HttpServletRequest request) {
        WebInvocationPrivilegeEvaluator privEvaluatorFromRequest = (WebInvocationPrivilegeEvaluator)request.getAttribute(WebAttributes.WEB_INVOCATION_PRIVILEGE_EVALUATOR_ATTRIBUTE);
        if (privEvaluatorFromRequest != null) {
            return privEvaluatorFromRequest;
        }
        ApplicationContext ctx = AuthUtils.getContext(servletContext);
        Map privilegeEvaluators = ctx.getBeansOfType(WebInvocationPrivilegeEvaluator.class);
        if (privilegeEvaluators.size() == 0) {
            throw new TemplateProcessingException("No visible WebInvocationPrivilegeEvaluator instance could be found in the application context. There must be at least one in order to support URL access checks in Spring Security authorization queries.");
        }
        return (WebInvocationPrivilegeEvaluator)privilegeEvaluators.values().toArray()[0];
    }

    public static ApplicationContext getContext(ServletContext servletContext) {
        return SpringSecurityWebApplicationContextUtils.findRequiredWebApplicationContext(servletContext);
    }
}

