/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity4.dialect.processor;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.thymeleaf.Arguments;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.extras.springsecurity4.auth.AuthUtils;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;

public class AuthorizeAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    public static final int ATTR_PRECEDENCE = 300;
    public static final String ATTR_NAME = "authorize";
    public static final String ATTR_NAME_EXPR = "authorize-expr";

    public AuthorizeAttrProcessor() {
        super(ATTR_NAME);
    }

    public AuthorizeAttrProcessor(String attrName) {
        super(attrName);
    }

    public int getPrecedence() {
        return 300;
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue == null || attributeValue.trim().equals("")) {
            return false;
        }
        IContext context = arguments.getContext();
        if (!(context instanceof IWebContext)) {
            throw new ConfigurationException("Thymeleaf execution context is not a web context (implementation of " + IWebContext.class.getName() + ". Spring Security integration can only be used in " + "web environements.");
        }
        IWebContext webContext = (IWebContext)context;
        HttpServletRequest request = webContext.getHttpServletRequest();
        HttpServletResponse response = webContext.getHttpServletResponse();
        ServletContext servletContext = webContext.getServletContext();
        Authentication authentication = AuthUtils.getAuthenticationObject();
        if (authentication == null) {
            return false;
        }
        return AuthUtils.authorizeUsingAccessExpression((IProcessingContext)arguments, attributeValue, authentication, request, response, servletContext);
    }
}

