/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.trait;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Optional;
import org.testifyproject.TestifyException;
import org.testifyproject.annotation.Fixture;
import org.testifyproject.trait.AnnotationTrait;
import org.testifyproject.trait.MemberTrait;
import org.testifyproject.trait.TypeTrait;

public interface FieldTrait
extends TypeTrait,
MemberTrait<Field>,
AnnotationTrait<Field> {
    @Override
    default public Field getAnnotatedElement() {
        return (Field)this.getMember();
    }

    default public void setValue(Object object, Object object2) {
        AccessController.doPrivileged(() -> {
            try {
                Field field = this.getAnnotatedElement();
                field.setAccessible(true);
                field.set(object, object2);
                return null;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                throw TestifyException.of(exception);
            }
        });
    }

    default public <T> Optional<T> getValue(Object object) {
        return AccessController.doPrivileged(() -> {
            try {
                Field field = this.getAnnotatedElement();
                field.setAccessible(true);
                return Optional.ofNullable(field.get(object));
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
                throw TestifyException.of(exception);
            }
        });
    }

    default public void init(Object object) {
        Optional<Fixture> optional = this.getAnnotation(Fixture.class);
        if (optional.isPresent()) {
            Fixture fixture = optional.get();
            Optional optional2 = this.getValue(object);
            if (optional2.isPresent()) {
                Object t = optional2.get();
                String string = fixture.init();
                if (!string.isEmpty()) {
                    this.invoke(t, string, new Object[0]);
                }
            }
        }
    }

    default public void destroy(Object object) {
        Optional<Fixture> optional = this.getAnnotation(Fixture.class);
        if (optional.isPresent()) {
            Fixture fixture = optional.get();
            Optional optional2 = this.getValue(object);
            if (optional2.isPresent()) {
                Object t = optional2.get();
                String string = fixture.destroy();
                if (!string.isEmpty()) {
                    this.invoke(t, string, new Object[0]);
                } else if (fixture.autoClose() && t instanceof AutoCloseable) {
                    this.invoke(t, "close", new Object[0]);
                }
            }
        }
    }
}

