/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.provider.bike;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;
import org.testcontainers.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import org.testcontainers.shaded.org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.testcontainers.shaded.org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.testcontainers.shaded.org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.bike.BIKEKEMExtractor;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.bike.BIKEKEMGenerator;
import org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.provider.bike.BCBIKEPrivateKey;
import org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.provider.bike.BCBIKEPublicKey;
import org.testcontainers.shaded.org.bouncycastle.util.Arrays;

public class BIKEKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCBIKEPublicKey bCBIKEPublicKey = (BCBIKEPublicKey)this.genSpec.getPublicKey();
            BIKEKEMGenerator bIKEKEMGenerator = new BIKEKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = bIKEKEMGenerator.generateEncapsulated(bCBIKEPublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCBIKEPrivateKey bCBIKEPrivateKey = (BCBIKEPrivateKey)this.extSpec.getPrivateKey();
        BIKEKEMExtractor bIKEKEMExtractor = new BIKEKEMExtractor(bCBIKEPrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = bIKEKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

