/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateConfigCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateSecretCmd;
import com.github.dockerjava.api.command.CreateServiceCmd;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InitializeSwarmCmd;
import com.github.dockerjava.api.command.InspectConfigCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectNetworkCmd;
import com.github.dockerjava.api.command.InspectServiceCmd;
import com.github.dockerjava.api.command.InspectSwarmCmd;
import com.github.dockerjava.api.command.InspectVolumeCmd;
import com.github.dockerjava.api.command.JoinSwarmCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.LeaveSwarmCmd;
import com.github.dockerjava.api.command.ListConfigsCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.command.ListServicesCmd;
import com.github.dockerjava.api.command.ListSwarmNodesCmd;
import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.command.ListVolumesCmd;
import com.github.dockerjava.api.command.LoadImageAsyncCmd;
import com.github.dockerjava.api.command.LoadImageCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.LogSwarmObjectCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveConfigCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RemoveSecretCmd;
import com.github.dockerjava.api.command.RemoveServiceCmd;
import com.github.dockerjava.api.command.RemoveSwarmNodeCmd;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.command.RenameContainerCmd;
import com.github.dockerjava.api.command.ResizeContainerCmd;
import com.github.dockerjava.api.command.ResizeExecCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SaveImagesCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.SyncDockerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.UpdateContainerCmd;
import com.github.dockerjava.api.command.UpdateServiceCmd;
import com.github.dockerjava.api.command.UpdateSwarmCmd;
import com.github.dockerjava.api.command.UpdateSwarmNodeCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Identifier;
import com.github.dockerjava.api.model.PruneType;
import com.github.dockerjava.api.model.SecretSpec;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.SwarmSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.AuditLogger;

class AuditLoggingDockerClient
implements DockerClient {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingDockerClient.class);
    private final DockerClient wrappedClient;

    public AuditLoggingDockerClient(DockerClient wrappedClient) {
        this.wrappedClient = wrappedClient;
    }

    public CreateContainerCmd createContainerCmd(@NotNull String image) {
        return this.wrappedCommand(CreateContainerCmd.class, this.wrappedClient.createContainerCmd(image), (cmd, res) -> AuditLogger.doLog("CREATE", image, res.getId(), cmd), (cmd, e) -> AuditLogger.doLog("CREATE", image, null, cmd, e));
    }

    public StartContainerCmd startContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StartContainerCmd.class, this.wrappedClient.startContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("START", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("START", null, containerId, cmd, e));
    }

    public RemoveContainerCmd removeContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(RemoveContainerCmd.class, this.wrappedClient.removeContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("REMOVE", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE", null, containerId, cmd, e));
    }

    public StopContainerCmd stopContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StopContainerCmd.class, this.wrappedClient.stopContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("STOP", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("STOP", null, containerId, cmd, e));
    }

    public KillContainerCmd killContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(KillContainerCmd.class, this.wrappedClient.killContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("KILL", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("KILL", null, containerId, cmd, e));
    }

    public CreateNetworkCmd createNetworkCmd() {
        return this.wrappedCommand(CreateNetworkCmd.class, this.wrappedClient.createNetworkCmd(), (cmd, res) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd, e));
    }

    public RemoveNetworkCmd removeNetworkCmd(@NotNull String networkId) {
        return this.wrappedCommand(RemoveNetworkCmd.class, this.wrappedClient.removeNetworkCmd(networkId), (cmd, res) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd, e));
    }

    private <T extends SyncDockerCmd<R>, R> T wrappedCommand(Class<T> clazz, T cmd, BiConsumer<T, R> successConsumer, BiConsumer<T, Exception> failureConsumer) {
        return (T)((SyncDockerCmd)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if (method.getName().equals("exec")) {
                try {
                    Object r = method.invoke((Object)cmd, args);
                    successConsumer.accept(cmd, r);
                    return r;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                        e = (Exception)e.getCause();
                    }
                    failureConsumer.accept(cmd, e);
                    throw e;
                }
            }
            return method.invoke((Object)cmd, args);
        }));
    }

    public AuthConfig authConfig() throws DockerException {
        return this.wrappedClient.authConfig();
    }

    public AuthCmd authCmd() {
        return this.wrappedClient.authCmd();
    }

    public InfoCmd infoCmd() {
        return this.wrappedClient.infoCmd();
    }

    public PingCmd pingCmd() {
        return this.wrappedClient.pingCmd();
    }

    public VersionCmd versionCmd() {
        return this.wrappedClient.versionCmd();
    }

    public PullImageCmd pullImageCmd(String repository) {
        return this.wrappedClient.pullImageCmd(repository);
    }

    public PushImageCmd pushImageCmd(String name) {
        return this.wrappedClient.pushImageCmd(name);
    }

    public PushImageCmd pushImageCmd(Identifier identifier) {
        return this.wrappedClient.pushImageCmd(identifier);
    }

    public CreateImageCmd createImageCmd(String repository, InputStream imageStream) {
        return this.wrappedClient.createImageCmd(repository, imageStream);
    }

    public LoadImageCmd loadImageCmd(InputStream imageStream) {
        return this.wrappedClient.loadImageCmd(imageStream);
    }

    public LoadImageAsyncCmd loadImageAsyncCmd(InputStream imageStream) {
        return this.wrappedClient.loadImageAsyncCmd(imageStream);
    }

    public SearchImagesCmd searchImagesCmd(String term) {
        return this.wrappedClient.searchImagesCmd(term);
    }

    public RemoveImageCmd removeImageCmd(String imageId) {
        return this.wrappedClient.removeImageCmd(imageId);
    }

    public ListImagesCmd listImagesCmd() {
        return this.wrappedClient.listImagesCmd();
    }

    public InspectImageCmd inspectImageCmd(String imageId) {
        return this.wrappedClient.inspectImageCmd(imageId);
    }

    public SaveImageCmd saveImageCmd(String name) {
        return this.wrappedClient.saveImageCmd(name);
    }

    public SaveImagesCmd saveImagesCmd() {
        return this.wrappedClient.saveImagesCmd();
    }

    public ListContainersCmd listContainersCmd() {
        return this.wrappedClient.listContainersCmd();
    }

    public ExecCreateCmd execCreateCmd(String containerId) {
        return this.wrappedClient.execCreateCmd(containerId);
    }

    public ResizeExecCmd resizeExecCmd(String execId) {
        return this.wrappedClient.resizeExecCmd(execId);
    }

    public InspectContainerCmd inspectContainerCmd(String containerId) {
        return this.wrappedClient.inspectContainerCmd(containerId);
    }

    public WaitContainerCmd waitContainerCmd(String containerId) {
        return this.wrappedClient.waitContainerCmd(containerId);
    }

    public AttachContainerCmd attachContainerCmd(String containerId) {
        return this.wrappedClient.attachContainerCmd(containerId);
    }

    public ExecStartCmd execStartCmd(String execId) {
        return this.wrappedClient.execStartCmd(execId);
    }

    public InspectExecCmd inspectExecCmd(String execId) {
        return this.wrappedClient.inspectExecCmd(execId);
    }

    public LogContainerCmd logContainerCmd(String containerId) {
        return this.wrappedClient.logContainerCmd(containerId);
    }

    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String containerId, String resource) {
        return this.wrappedClient.copyArchiveFromContainerCmd(containerId, resource);
    }

    @Deprecated
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String containerId, String resource) {
        return this.wrappedClient.copyFileFromContainerCmd(containerId, resource);
    }

    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String containerId) {
        return this.wrappedClient.copyArchiveToContainerCmd(containerId);
    }

    public ContainerDiffCmd containerDiffCmd(String containerId) {
        return this.wrappedClient.containerDiffCmd(containerId);
    }

    public UpdateContainerCmd updateContainerCmd(String containerId) {
        return this.wrappedClient.updateContainerCmd(containerId);
    }

    public RenameContainerCmd renameContainerCmd(String containerId) {
        return this.wrappedClient.renameContainerCmd(containerId);
    }

    public RestartContainerCmd restartContainerCmd(String containerId) {
        return this.wrappedClient.restartContainerCmd(containerId);
    }

    public ResizeContainerCmd resizeContainerCmd(String containerId) {
        return this.wrappedClient.resizeContainerCmd(containerId);
    }

    public CommitCmd commitCmd(String containerId) {
        return this.wrappedClient.commitCmd(containerId);
    }

    public BuildImageCmd buildImageCmd() {
        return this.wrappedClient.buildImageCmd();
    }

    public BuildImageCmd buildImageCmd(File dockerFileOrFolder) {
        return this.wrappedClient.buildImageCmd(dockerFileOrFolder);
    }

    public BuildImageCmd buildImageCmd(InputStream tarInputStream) {
        return this.wrappedClient.buildImageCmd(tarInputStream);
    }

    public TopContainerCmd topContainerCmd(String containerId) {
        return this.wrappedClient.topContainerCmd(containerId);
    }

    public TagImageCmd tagImageCmd(String imageId, String imageNameWithRepository, String tag) {
        return this.wrappedClient.tagImageCmd(imageId, imageNameWithRepository, tag);
    }

    public PauseContainerCmd pauseContainerCmd(String containerId) {
        return this.wrappedClient.pauseContainerCmd(containerId);
    }

    public UnpauseContainerCmd unpauseContainerCmd(String containerId) {
        return this.wrappedClient.unpauseContainerCmd(containerId);
    }

    public EventsCmd eventsCmd() {
        return this.wrappedClient.eventsCmd();
    }

    public StatsCmd statsCmd(String containerId) {
        return this.wrappedClient.statsCmd(containerId);
    }

    public CreateVolumeCmd createVolumeCmd() {
        return this.wrappedClient.createVolumeCmd();
    }

    public InspectVolumeCmd inspectVolumeCmd(String name) {
        return this.wrappedClient.inspectVolumeCmd(name);
    }

    public RemoveVolumeCmd removeVolumeCmd(String name) {
        return this.wrappedClient.removeVolumeCmd(name);
    }

    public ListVolumesCmd listVolumesCmd() {
        return this.wrappedClient.listVolumesCmd();
    }

    public ListNetworksCmd listNetworksCmd() {
        return this.wrappedClient.listNetworksCmd();
    }

    public InspectNetworkCmd inspectNetworkCmd() {
        return this.wrappedClient.inspectNetworkCmd();
    }

    public ConnectToNetworkCmd connectToNetworkCmd() {
        return this.wrappedClient.connectToNetworkCmd();
    }

    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return this.wrappedClient.disconnectFromNetworkCmd();
    }

    public InitializeSwarmCmd initializeSwarmCmd(SwarmSpec swarmSpec) {
        return this.wrappedClient.initializeSwarmCmd(swarmSpec);
    }

    public InspectSwarmCmd inspectSwarmCmd() {
        return this.wrappedClient.inspectSwarmCmd();
    }

    public JoinSwarmCmd joinSwarmCmd() {
        return this.wrappedClient.joinSwarmCmd();
    }

    public LeaveSwarmCmd leaveSwarmCmd() {
        return this.wrappedClient.leaveSwarmCmd();
    }

    public UpdateSwarmCmd updateSwarmCmd(SwarmSpec swarmSpec) {
        return this.wrappedClient.updateSwarmCmd(swarmSpec);
    }

    public UpdateSwarmNodeCmd updateSwarmNodeCmd() {
        return this.wrappedClient.updateSwarmNodeCmd();
    }

    public RemoveSwarmNodeCmd removeSwarmNodeCmd(String swarmNodeId) {
        return this.wrappedClient.removeSwarmNodeCmd(swarmNodeId);
    }

    public ListSwarmNodesCmd listSwarmNodesCmd() {
        return this.wrappedClient.listSwarmNodesCmd();
    }

    public ListServicesCmd listServicesCmd() {
        return this.wrappedClient.listServicesCmd();
    }

    public CreateServiceCmd createServiceCmd(ServiceSpec serviceSpec) {
        return this.wrappedClient.createServiceCmd(serviceSpec);
    }

    public InspectServiceCmd inspectServiceCmd(String serviceId) {
        return this.wrappedClient.inspectServiceCmd(serviceId);
    }

    public UpdateServiceCmd updateServiceCmd(String serviceId, ServiceSpec serviceSpec) {
        return this.wrappedClient.updateServiceCmd(serviceId, serviceSpec);
    }

    public RemoveServiceCmd removeServiceCmd(String serviceId) {
        return this.wrappedClient.removeServiceCmd(serviceId);
    }

    public ListTasksCmd listTasksCmd() {
        return this.wrappedClient.listTasksCmd();
    }

    public LogSwarmObjectCmd logServiceCmd(String serviceId) {
        return this.wrappedClient.logServiceCmd(serviceId);
    }

    public LogSwarmObjectCmd logTaskCmd(String taskId) {
        return this.wrappedClient.logTaskCmd(taskId);
    }

    public PruneCmd pruneCmd(PruneType pruneType) {
        return this.wrappedClient.pruneCmd(pruneType);
    }

    public ListSecretsCmd listSecretsCmd() {
        return this.wrappedClient.listSecretsCmd();
    }

    public CreateSecretCmd createSecretCmd(SecretSpec secretSpec) {
        return this.wrappedClient.createSecretCmd(secretSpec);
    }

    public RemoveSecretCmd removeSecretCmd(String secretId) {
        return this.wrappedClient.removeSecretCmd(secretId);
    }

    public ListConfigsCmd listConfigsCmd() {
        return this.wrappedClient.listConfigsCmd();
    }

    public CreateConfigCmd createConfigCmd() {
        return this.wrappedClient.createConfigCmd();
    }

    public InspectConfigCmd inspectConfigCmd(String configId) {
        return this.wrappedClient.inspectConfigCmd(configId);
    }

    public RemoveConfigCmd removeConfigCmd(String configId) {
        return this.wrappedClient.removeConfigCmd(configId);
    }

    public void close() throws IOException {
        this.wrappedClient.close();
    }

    private static interface InterceptedMethods {
        public CreateContainerCmd createContainerCmd(String var1);

        public StartContainerCmd startContainerCmd(String var1);

        public RemoveContainerCmd removeContainerCmd(String var1);

        public StopContainerCmd stopContainerCmd(String var1);

        public KillContainerCmd killContainerCmd(String var1);

        public CreateNetworkCmd createNetworkCmd();

        public RemoveNetworkCmd removeNetworkCmd(String var1);
    }
}

