/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.provider.hqc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Set;
import org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.hqc.HQCPrivateKeyParameters;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.interfaces.HQCKey;
import org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.spec.HQCParameterSpec;
import org.testcontainers.shaded.org.bouncycastle.util.Arrays;

public class BCHQCPrivateKey
implements PrivateKey,
HQCKey {
    private static final long serialVersionUID = 1L;
    private transient HQCPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCHQCPrivateKey(HQCPrivateKeyParameters hQCPrivateKeyParameters) {
        this.params = hQCPrivateKeyParameters;
    }

    public BCHQCPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (HQCPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCHQCPrivateKey) {
            BCHQCPrivateKey bCHQCPrivateKey = (BCHQCPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCHQCPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "HQC";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public HQCParameterSpec getParameterSpec() {
        return HQCParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    HQCPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

