/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.provider.frodo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.testcontainers.shaded.org.bouncycastle.asn1.ASN1Set;
import org.testcontainers.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.testcontainers.shaded.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.interfaces.FrodoKey;
import org.testcontainers.shaded.org.bouncycastle.pqc.jcajce.spec.FrodoParameterSpec;
import org.testcontainers.shaded.org.bouncycastle.util.Arrays;

public class BCFrodoPrivateKey
implements PrivateKey,
FrodoKey {
    private static final long serialVersionUID = 1L;
    private transient FrodoPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCFrodoPrivateKey(FrodoPrivateKeyParameters frodoPrivateKeyParameters) {
        this.params = frodoPrivateKeyParameters;
    }

    public BCFrodoPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (FrodoPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCFrodoPrivateKey) {
            BCFrodoPrivateKey bCFrodoPrivateKey = (BCFrodoPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCFrodoPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "Frodo";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public FrodoParameterSpec getParameterSpec() {
        return FrodoParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    FrodoPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

