/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.utility.TestEnvironment;

public final class ExecInContainerPattern {
    private static final Logger log = LoggerFactory.getLogger(ExecInContainerPattern.class);

    @Deprecated
    public static Container.ExecResult execInContainer(InspectContainerResponse containerInfo, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        return ExecInContainerPattern.execInContainer(dockerClient, containerInfo, command);
    }

    @Deprecated
    public static Container.ExecResult execInContainer(InspectContainerResponse containerInfo, Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        return ExecInContainerPattern.execInContainerWithUser(dockerClient, containerInfo, outputCharset, null, command);
    }

    public static Container.ExecResult execInContainer(DockerClient dockerClient, InspectContainerResponse containerInfo, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainerWithUser(dockerClient, containerInfo, StandardCharsets.UTF_8, null, command);
    }

    public static Container.ExecResult execInContainer(DockerClient dockerClient, InspectContainerResponse containerInfo, Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainerWithUser(dockerClient, containerInfo, outputCharset, null, command);
    }

    public static Container.ExecResult execInContainerWithUser(DockerClient dockerClient, InspectContainerResponse containerInfo, String user, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainerWithUser(dockerClient, containerInfo, StandardCharsets.UTF_8, user, command);
    }

    public static Container.ExecResult execInContainerWithUser(DockerClient dockerClient, InspectContainerResponse containerInfo, Charset outputCharset, String user, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        if (!TestEnvironment.dockerExecutionDriverSupportsExec()) {
            throw new UnsupportedOperationException("Your docker daemon is running the \"lxc\" driver, which doesn't support \"docker exec\".");
        }
        if (!ExecInContainerPattern.isRunning(containerInfo)) {
            throw new IllegalStateException("execInContainer can only be used while the Container is running");
        }
        String containerId = containerInfo.getId();
        String containerName = containerInfo.getName();
        log.debug("{}: Running \"exec\" command: {}", (Object)containerName, (Object)String.join((CharSequence)" ", command));
        ExecCreateCmd execCreateCmd = dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(command);
        if (user != null && !user.isEmpty()) {
            log.debug("{}: Running \"exec\" command with user: {}", (Object)containerName, (Object)user);
            execCreateCmd.withUser(user);
        }
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)execCreateCmd.exec();
        ToStringConsumer stdoutConsumer = new ToStringConsumer();
        ToStringConsumer stderrConsumer = new ToStringConsumer();
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, stdoutConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, stderrConsumer);
            ((FrameConsumerResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)callback)).awaitCompletion();
        }
        int exitCode = dockerClient.inspectExecCmd(execCreateCmdResponse.getId()).exec().getExitCodeLong().intValue();
        Container.ExecResult result = new Container.ExecResult(exitCode, stdoutConsumer.toString(outputCharset), stderrConsumer.toString(outputCharset));
        log.trace("{}: stdout: {}", (Object)containerName, (Object)result.getStdout());
        log.trace("{}: stderr: {}", (Object)containerName, (Object)result.getStderr());
        return result;
    }

    private static boolean isRunning(InspectContainerResponse containerInfo) {
        try {
            return containerInfo != null && containerInfo.getState().getRunning() != false;
        }
        catch (DockerException e) {
            return false;
        }
    }

    private ExecInContainerPattern() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

