/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ComposeServiceWaitStrategyTarget;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.ContainerisedDockerCompose;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.DockerComposeFiles;
import org.testcontainers.containers.FutureContainer;
import org.testcontainers.containers.LocalDockerCompose;
import org.testcontainers.containers.SocatContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.com.google.common.collect.Sets;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.LogUtils;
import org.testcontainers.utility.ResourceReaper;

class ComposeDelegate {
    private static final Logger log = LoggerFactory.getLogger(ComposeDelegate.class);
    private final ComposeVersion composeVersion;
    private final String composeSeparator;
    private final DockerClient dockerClient;
    private final List<File> composeFiles;
    private final DockerComposeFiles dockerComposeFiles;
    private final String identifier;
    private final String project;
    private final String executable;
    private final DockerImageName defaultImageName;
    private final AtomicInteger nextAmbassadorPort = new AtomicInteger(2000);
    private final Map<String, Map<Integer, Integer>> ambassadorPortMappings = new ConcurrentHashMap<String, Map<Integer, Integer>>();
    private final Map<String, List<Consumer<OutputFrame>>> logConsumers = new ConcurrentHashMap<String, List<Consumer<OutputFrame>>>();
    private final SocatContainer ambassadorContainer = new SocatContainer();
    private final Map<String, ComposeServiceWaitStrategyTarget> serviceInstanceMap = new ConcurrentHashMap<String, ComposeServiceWaitStrategyTarget>();
    private final Map<String, WaitAllStrategy> waitStrategyMap = new ConcurrentHashMap<String, WaitAllStrategy>();
    private Duration startupTimeout = Duration.ofMinutes(30L);

    ComposeDelegate(ComposeVersion composeVersion, List<File> composeFiles, String identifier, String executable, DockerImageName defaultImageName) {
        this.composeVersion = composeVersion;
        this.composeSeparator = composeVersion.getSeparator();
        this.dockerClient = DockerClientFactory.lazyClient();
        this.composeFiles = composeFiles;
        this.dockerComposeFiles = new DockerComposeFiles(this.composeFiles);
        this.identifier = identifier.toLowerCase();
        this.project = this.randomProjectId();
        this.executable = executable;
        this.defaultImageName = defaultImageName;
    }

    void pullImages() {
        this.dockerComposeFiles.getDependencyImages().forEach(imageName -> {
            try {
                log.info("Preemptively checking local images for '{}', referenced via a compose file or transitive Dockerfile. If not available, it will be pulled.", imageName);
                new RemoteDockerImage(DockerImageName.parse(imageName)).withImageNameSubstitutor(ImageNameSubstitutor.noop()).get();
            }
            catch (Exception e) {
                log.warn("Unable to pre-fetch an image ({}) depended upon by Docker Compose build - startup will continue but may fail. Exception message was: {}", imageName, (Object)e.getMessage());
            }
        });
    }

    void createServices(boolean localCompose, boolean build, Set<String> options, List<String> services, Map<String, Integer> scalingPreferences, Map<String, String> env) {
        String serviceNameArgs = Stream.concat(services.stream(), scalingPreferences.keySet().stream()).distinct().collect(Collectors.joining(" "));
        String scalingOptions = scalingPreferences.entrySet().stream().map(entry -> "--scale " + (String)entry.getKey() + "=" + entry.getValue()).distinct().collect(Collectors.joining(" "));
        String command = this.getUpCommand(this.optionsAsString(options));
        if (build) {
            command = command + " --build";
        }
        if (!Strings.isNullOrEmpty(scalingOptions)) {
            command = command + " " + scalingOptions;
        }
        if (!Strings.isNullOrEmpty(serviceNameArgs)) {
            command = command + " " + serviceNameArgs;
        }
        this.runWithCompose(localCompose, command, env);
    }

    private String getUpCommand(String options) {
        if (options == null || options.equals("")) {
            return this.composeVersion == ComposeVersion.V1 ? "up -d" : "compose up -d";
        }
        String cmd = this.composeVersion == ComposeVersion.V1 ? "%s up -d" : "compose %s up -d";
        return String.format(cmd, options);
    }

    private String optionsAsString(Set<String> options) {
        String optionsString = options.stream().collect(Collectors.joining(" "));
        if (optionsString.length() != 0) {
            return optionsString;
        }
        return "";
    }

    void waitUntilServiceStarted(boolean tailChildContainers) {
        this.listChildContainers().forEach(container -> this.createServiceInstance((Container)container, tailChildContainers));
        Set<String> servicesToWaitFor = this.waitStrategyMap.keySet();
        Set<String> instantiatedServices = this.serviceInstanceMap.keySet();
        Sets.SetView<String> missingServiceInstances = Sets.difference(servicesToWaitFor, instantiatedServices);
        if (!missingServiceInstances.isEmpty()) {
            throw new IllegalStateException("Services named " + missingServiceInstances + " do not exist, but wait conditions have been defined for them. This might mean that you misspelled the service name when defining the wait condition.");
        }
        this.serviceInstanceMap.forEach(this::waitUntilServiceStarted);
    }

    private void createServiceInstance(Container container, boolean tailChildContainers) {
        String serviceName = this.getServiceNameFromContainer(container);
        ComposeServiceWaitStrategyTarget containerInstance = new ComposeServiceWaitStrategyTarget(this.dockerClient, container, this.ambassadorContainer, this.ambassadorPortMappings.getOrDefault(serviceName, new HashMap()));
        String containerId = containerInstance.getContainerId();
        if (tailChildContainers) {
            this.followLogs(containerId, new Slf4jLogConsumer(log).withPrefix(container.getNames()[0]));
        }
        this.logConsumers.getOrDefault(serviceName, Collections.emptyList()).forEach(consumer -> this.followLogs(containerId, (Consumer<OutputFrame>)consumer));
        this.serviceInstanceMap.putIfAbsent(serviceName, containerInstance);
    }

    private void waitUntilServiceStarted(String serviceName, ComposeServiceWaitStrategyTarget serviceInstance) {
        WaitAllStrategy waitAllStrategy = this.waitStrategyMap.get(serviceName);
        if (waitAllStrategy != null) {
            waitAllStrategy.waitUntilReady(serviceInstance);
        }
    }

    private String getServiceNameFromContainer(Container container) {
        String containerName = (String)container.getLabels().get("com.docker.compose.service");
        String containerNumber = (String)container.getLabels().get("com.docker.compose.container-number");
        return String.format("%s%s%s", containerName, this.composeSeparator, containerNumber);
    }

    public void runWithCompose(boolean localCompose, String cmd) {
        this.runWithCompose(localCompose, cmd, Collections.emptyMap());
    }

    public void runWithCompose(boolean localCompose, String cmd, Map<String, String> env) {
        Preconditions.checkNotNull(this.composeFiles);
        Preconditions.checkArgument(!this.composeFiles.isEmpty(), "No docker compose file have been provided");
        DockerCompose dockerCompose = localCompose ? new LocalDockerCompose(this.executable, this.composeFiles, this.project) : new ContainerisedDockerCompose(this.defaultImageName, this.composeFiles, this.project);
        dockerCompose.withCommand(cmd).withEnv(env).invoke();
    }

    void registerContainersForShutdown() {
        ResourceReaper.instance().registerLabelsFilterForCleanup(Collections.singletonMap("com.docker.compose.project", this.project));
    }

    @VisibleForTesting
    List<Container> listChildContainers() {
        return ((List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).exec()).stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/" + this.project))).collect(Collectors.toList());
    }

    void startAmbassadorContainer() {
        if (!this.ambassadorPortMappings.isEmpty()) {
            this.ambassadorContainer.start();
        }
    }

    public void withExposedService(String serviceName, int servicePort) {
        this.withExposedService(serviceName, servicePort, Wait.defaultWaitStrategy());
    }

    public void withExposedService(String serviceName, int instance, int servicePort) {
        this.withExposedService(serviceName + this.composeSeparator + instance, servicePort);
    }

    public void withExposedService(String serviceName, int instance, int servicePort, WaitStrategy waitStrategy) {
        this.withExposedService(serviceName + this.composeSeparator + instance, servicePort, waitStrategy);
    }

    public void withExposedService(String serviceName, int servicePort, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        int ambassadorPort = this.nextAmbassadorPort.getAndIncrement();
        this.ambassadorPortMappings.computeIfAbsent(serviceInstanceName, __ -> new ConcurrentHashMap()).put(servicePort, ambassadorPort);
        this.ambassadorContainer.withTarget(ambassadorPort, serviceInstanceName, servicePort);
        this.ambassadorContainer.addLink(new FutureContainer(this.project + this.composeSeparator + serviceInstanceName), serviceInstanceName);
        this.addWaitStrategy(serviceInstanceName, waitStrategy);
    }

    String getServiceInstanceName(String serviceName) {
        String serviceInstanceName = serviceName;
        String regex = String.format(".*%s[0-9]+", this.composeSeparator);
        if (!serviceInstanceName.matches(regex)) {
            serviceInstanceName = serviceInstanceName + String.format("%s1", this.composeSeparator);
        }
        return serviceInstanceName;
    }

    void addWaitStrategy(String serviceInstanceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        WaitAllStrategy waitAllStrategy = this.waitStrategyMap.computeIfAbsent(serviceInstanceName, __ -> new WaitAllStrategy(WaitAllStrategy.Mode.WITH_MAXIMUM_OUTER_TIMEOUT).withStartupTimeout(this.startupTimeout));
        waitAllStrategy.withStrategy(waitStrategy);
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        Map<Integer, Integer> portMap = this.ambassadorPortMappings.get(this.getServiceInstanceName(serviceName));
        if (portMap == null) {
            throw new IllegalArgumentException("Could not get a port for '" + serviceName + "'. Testcontainers does not have an exposed port configured for '" + serviceName + "'. To fix, please ensure that the service '" + serviceName + "' has ports exposed using .withExposedService(...)");
        }
        return this.ambassadorContainer.getMappedPort(portMap.get(servicePort));
    }

    Optional<ContainerState> getContainerByServiceName(String serviceName) {
        String serviceInstantName = this.getServiceInstanceName(serviceName);
        return Optional.ofNullable(this.serviceInstanceMap.get(serviceInstantName));
    }

    private void followLogs(String containerId, Consumer<OutputFrame> consumer) {
        LogUtils.followOutput(this.dockerClient, containerId, consumer);
    }

    String randomProjectId() {
        return this.identifier + Base58.randomString(6).toLowerCase();
    }

    void withLogConsumer(String serviceName, Consumer<OutputFrame> consumer) {
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        List consumers = this.logConsumers.getOrDefault(serviceInstanceName, new ArrayList());
        consumers.add(consumer);
        this.logConsumers.putIfAbsent(serviceInstanceName, consumers);
    }

    String getServiceHost() {
        return this.ambassadorContainer.getHost();
    }

    public String getProject() {
        return this.project;
    }

    public SocatContainer getAmbassadorContainer() {
        return this.ambassadorContainer;
    }

    public void setStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    static enum ComposeVersion {
        V1("_"),
        V2("-");

        private final String separator;

        private ComposeVersion(String separator) {
            this.separator = separator;
        }

        public String getSeparator() {
            return this.separator;
        }
    }
}

