/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.strategy;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.timeouts.Timeouts;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public class WaitAllStrategy
implements WaitStrategy {
    private final Mode mode;
    private final List<WaitStrategy> strategies = new ArrayList<WaitStrategy>();
    private Duration timeout = Duration.ofSeconds(30L);

    public WaitAllStrategy() {
        this(Mode.WITH_OUTER_TIMEOUT);
    }

    public WaitAllStrategy(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void waitUntilReady(WaitStrategyTarget waitStrategyTarget) {
        if (this.mode == Mode.WITH_INDIVIDUAL_TIMEOUTS_ONLY) {
            this.waitUntilNestedStrategiesAreReady(waitStrategyTarget);
        } else {
            Timeouts.doWithTimeout((int)((int)this.timeout.toMillis()), (TimeUnit)TimeUnit.MILLISECONDS, () -> this.waitUntilNestedStrategiesAreReady(waitStrategyTarget));
        }
    }

    private void waitUntilNestedStrategiesAreReady(WaitStrategyTarget waitStrategyTarget) {
        for (WaitStrategy strategy : this.strategies) {
            strategy.waitUntilReady(waitStrategyTarget);
        }
    }

    public WaitAllStrategy withStrategy(WaitStrategy strategy) {
        if (this.mode == Mode.WITH_OUTER_TIMEOUT) {
            this.applyStartupTimeout(strategy);
        }
        this.strategies.add(strategy);
        return this;
    }

    @Override
    public WaitAllStrategy withStartupTimeout(Duration startupTimeout) {
        if (this.mode == Mode.WITH_INDIVIDUAL_TIMEOUTS_ONLY) {
            throw new IllegalStateException(String.format("Changing startup timeout is not supported with mode %s", new Object[]{Mode.WITH_INDIVIDUAL_TIMEOUTS_ONLY}));
        }
        this.timeout = startupTimeout;
        this.strategies.forEach(this::applyStartupTimeout);
        return this;
    }

    private void applyStartupTimeout(WaitStrategy childStrategy) {
        childStrategy.withStartupTimeout(this.timeout);
    }

    public static enum Mode {
        WITH_OUTER_TIMEOUT,
        WITH_INDIVIDUAL_TIMEOUTS_ONLY,
        WITH_MAXIMUM_OUTER_TIMEOUT;

    }
}

