/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import java.util.Locale;
import java.util.Map;
import org.testcontainers.shaded.freemarker.core.AliasTargetTemplateValueFormatException;
import org.testcontainers.shaded.freemarker.core.Environment;
import org.testcontainers.shaded.freemarker.core.TemplateFormatUtil;
import org.testcontainers.shaded.freemarker.core.TemplateNumberFormat;
import org.testcontainers.shaded.freemarker.core.TemplateNumberFormatFactory;
import org.testcontainers.shaded.freemarker.core.TemplateValueFormatException;
import org.testcontainers.shaded.freemarker.core._CoreLocaleUtils;
import org.testcontainers.shaded.freemarker.template.utility.StringUtil;

public final class AliasTemplateNumberFormatFactory
extends TemplateNumberFormatFactory {
    private final String defaultTargetFormatString;
    private final Map<Locale, String> localizedTargetFormatStrings;

    public AliasTemplateNumberFormatFactory(String targetFormatString) {
        this.defaultTargetFormatString = targetFormatString;
        this.localizedTargetFormatStrings = null;
    }

    public AliasTemplateNumberFormatFactory(String defaultTargetFormatString, Map<Locale, String> localizedTargetFormatStrings) {
        this.defaultTargetFormatString = defaultTargetFormatString;
        this.localizedTargetFormatStrings = localizedTargetFormatStrings;
    }

    @Override
    public TemplateNumberFormat get(String params, Locale locale, Environment env) throws TemplateValueFormatException {
        TemplateFormatUtil.checkHasNoParameters(params);
        try {
            String targetFormatString;
            if (this.localizedTargetFormatStrings != null) {
                Locale lookupLocale = locale;
                targetFormatString = this.localizedTargetFormatStrings.get(lookupLocale);
                while (targetFormatString == null && (lookupLocale = _CoreLocaleUtils.getLessSpecificLocale(lookupLocale)) != null) {
                    targetFormatString = this.localizedTargetFormatStrings.get(lookupLocale);
                }
            } else {
                targetFormatString = null;
            }
            if (targetFormatString == null) {
                targetFormatString = this.defaultTargetFormatString;
            }
            return env.getTemplateNumberFormat(targetFormatString, locale);
        }
        catch (TemplateValueFormatException e) {
            throw new AliasTargetTemplateValueFormatException("Failed to create format based on target format string,  " + StringUtil.jQuote(params) + ". Reason given: " + e.getMessage(), e);
        }
    }
}

