/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.openfga;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class OpenFGAContainer
extends GenericContainer<OpenFGAContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"openfga/openfga");

    public OpenFGAContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public OpenFGAContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{3000, 8080, 8081});
        this.withCommand("run");
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/healthz").forPort(8080).forResponsePredicate(response -> response.contains("SERVING")));
    }

    public String getHttpEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(8080);
    }

    public String getGrpcEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(8081);
    }
}

