/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.LicenseAcceptance;

@Deprecated
public class MSSQLServerContainer<SELF extends MSSQLServerContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mcr.microsoft.com/mssql/server");
    @Deprecated
    public static final String DEFAULT_TAG = "2017-CU12";
    public static final String NAME = "sqlserver";
    public static final String IMAGE = DEFAULT_IMAGE_NAME.getUnversionedPart();
    public static final Integer MS_SQL_SERVER_PORT = 1433;
    static final String DEFAULT_USER = "sa";
    static final String DEFAULT_PASSWORD = "A_Str0ng_Required_Password";
    private String password = "A_Str0ng_Required_Password";
    private static final int DEFAULT_STARTUP_TIMEOUT_SECONDS = 240;
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 240;
    private static final Pattern[] PASSWORD_CATEGORY_VALIDATION_PATTERNS = new Pattern[]{Pattern.compile("[A-Z]+"), Pattern.compile("[a-z]+"), Pattern.compile("[0-9]+"), Pattern.compile("[^a-zA-Z0-9]+", 2)};

    @Deprecated
    public MSSQLServerContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public MSSQLServerContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public MSSQLServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withStartupTimeoutSeconds(240);
        this.withConnectTimeoutSeconds(240);
        this.addExposedPort(MS_SQL_SERVER_PORT);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return super.getLivenessCheckPortNumbers();
    }

    protected void configure() {
        if (!this.getEnvMap().containsKey("ACCEPT_EULA")) {
            LicenseAcceptance.assertLicenseAccepted((String)this.getDockerImageName());
            this.acceptLicense();
        }
        this.addEnv("MSSQL_SA_PASSWORD", this.password);
    }

    public SELF acceptLicense() {
        this.addEnv("ACCEPT_EULA", "Y");
        return (SELF)((Object)((MSSQLServerContainer)this.self()));
    }

    public String getDriverClassName() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    protected String constructUrlForConnection(String queryString) {
        if (this.urlParameters.keySet().stream().map(String::toLowerCase).noneMatch("encrypt"::equals)) {
            this.urlParameters.put("encrypt", "false");
        }
        return super.constructUrlForConnection(queryString);
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters(";", ";");
        return "jdbc:sqlserver://" + this.getHost() + ":" + this.getMappedPort(MS_SQL_SERVER_PORT) + additionalUrlParams;
    }

    public String getUsername() {
        return DEFAULT_USER;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withPassword(String password) {
        this.checkPasswordStrength(password);
        this.password = password;
        return (SELF)((Object)((MSSQLServerContainer)this.self()));
    }

    private void checkPasswordStrength(String password) {
        if (password == null) {
            throw new IllegalArgumentException("Null password is not allowed");
        }
        if (password.length() < 8) {
            throw new IllegalArgumentException("Password should be at least 8 characters long");
        }
        if (password.length() > 128) {
            throw new IllegalArgumentException("Password can be up to 128 characters long");
        }
        long satisfiedCategories = Stream.of(PASSWORD_CATEGORY_VALIDATION_PATTERNS).filter(p -> p.matcher(password).find()).count();
        if (satisfiedCategories < 3L) {
            throw new IllegalArgumentException("Password must contain characters from three of the following four categories:\n - Latin uppercase letters (A through Z)\n - Latin lowercase letters (a through z)\n - Base 10 digits (0 through 9)\n - Non-alphanumeric characters such as: exclamation point (!), dollar sign ($), number sign (#), or percent (%).");
        }
    }
}

