/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.mockserver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class MockServerContainer
extends GenericContainer<MockServerContainer> {
    private static final Logger log = LoggerFactory.getLogger(MockServerContainer.class);
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"jamesdbloom/mockserver");
    private static final String DEFAULT_TAG = "mockserver-5.5.4";
    @Deprecated
    public static final String VERSION = "mockserver-5.5.4";
    public static final int PORT = 1080;

    @Deprecated
    public MockServerContainer(String version) {
        this(DEFAULT_IMAGE_NAME.withTag("mockserver-" + version));
    }

    public MockServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, DockerImageName.parse((String)"mockserver/mockserver")});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*started on port: 1080.*", (int)1));
        this.withCommand("-serverPort 1080");
        this.addExposedPorts(new int[]{1080});
    }

    public String getEndpoint() {
        return String.format("http://%s:%d", this.getHost(), this.getMappedPort(1080));
    }

    public String getSecureEndpoint() {
        return String.format("https://%s:%d", this.getHost(), this.getMappedPort(1080));
    }

    public Integer getServerPort() {
        return this.getMappedPort(1080);
    }
}

