/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.Parameter;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.provider.MethodSource;
import org.testcontainers.jdbc.ConnectionUrl;
import org.testcontainers.jdbc.ContainerDatabaseDriver;

@ParameterizedClass
@MethodSource(value={"data"})
public class AbstractJDBCDriverTest {
    @Parameter(value=0)
    public String jdbcUrl;
    @Parameter(value=1)
    public EnumSet<Options> options;

    public static void sampleInitFunction(Connection connection) throws SQLException {
        connection.createStatement().execute("CREATE TABLE bar (\n  foo VARCHAR(255)\n);");
        connection.createStatement().execute("INSERT INTO bar (foo) VALUES ('hello world');");
        connection.createStatement().execute("CREATE TABLE my_counter (\n  n INT\n);");
    }

    @AfterAll
    public static void testCleanup() {
        ContainerDatabaseDriver.killContainers();
    }

    @Test
    void test() throws SQLException {
        try (HikariDataSource dataSource = this.getDataSource(this.jdbcUrl, 1);){
            this.performSimpleTest(dataSource);
            if (this.options.contains((Object)Options.ScriptedSchema)) {
                this.performTestForScriptedSchema(dataSource);
            }
            if (this.options.contains((Object)Options.JDBCParams)) {
                this.performTestForJDBCParamUsage(dataSource);
            }
            if (this.options.contains((Object)Options.CharacterSet)) {
                this.performSimpleTestWithCharacterSet(this.jdbcUrl);
                this.performTestForCharacterEncodingForInitialScriptConnection(dataSource);
            }
            if (this.options.contains((Object)Options.CustomIniFile)) {
                this.performTestForCustomIniFile(dataSource);
            }
        }
    }

    private void performSimpleTest(HikariDataSource dataSource) throws SQLException {
        String query = "SELECT 1";
        if (this.jdbcUrl.startsWith("jdbc:tc:db2:")) {
            query = "SELECT 1 FROM SYSIBM.SYSDUMMY1";
        }
        boolean result = (Boolean)new QueryRunner((DataSource)dataSource, this.options.contains((Object)Options.PmdKnownBroken)).query(query, rs -> {
            rs.next();
            int resultSetInt = rs.getInt(1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resultSetInt).as("A basic SELECT query succeeds", new Object[0])).isEqualTo(1);
            return true;
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("The database returned a record as expected", new Object[0])).isTrue();
    }

    private void performTestForScriptedSchema(HikariDataSource dataSource) throws SQLException {
        boolean result = (Boolean)new QueryRunner((DataSource)dataSource).query("SELECT foo FROM bar WHERE foo LIKE '%world'", rs -> {
            rs.next();
            String resultSetString = rs.getString(1);
            ((AbstractStringAssert)Assertions.assertThat((String)resultSetString).as("A basic SELECT query succeeds where the schema has been applied from a script", new Object[0])).isEqualTo("hello world");
            return true;
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("The database returned a record as expected", new Object[0])).isTrue();
    }

    private void performTestForJDBCParamUsage(HikariDataSource dataSource) throws SQLException {
        boolean result = (Boolean)new QueryRunner((DataSource)dataSource).query("select CURRENT_USER", rs -> {
            rs.next();
            String resultUser = rs.getString(1);
            if (resultUser.endsWith("@%")) {
                resultUser = resultUser.substring(0, resultUser.length() - 2);
            }
            ((AbstractStringAssert)Assertions.assertThat((String)resultUser).as("User from query param is created.", new Object[0])).isEqualTo("someuser");
            return true;
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("The database returned a record as expected", new Object[0])).isTrue();
        String databaseQuery = "SELECT DATABASE()";
        String databaseType = ConnectionUrl.newInstance((String)this.jdbcUrl).getDatabaseType();
        if (databaseType.equalsIgnoreCase("postgresql") || databaseType.equalsIgnoreCase("postgis") || databaseType.equalsIgnoreCase("timescaledb") || databaseType.equalsIgnoreCase("pgvector")) {
            databaseQuery = "SELECT CURRENT_DATABASE()";
        }
        result = (Boolean)new QueryRunner((DataSource)dataSource).query(databaseQuery, rs -> {
            rs.next();
            String resultDB = rs.getString(1);
            ((AbstractStringAssert)Assertions.assertThat((String)resultDB).as("Database name from URL String is used.", new Object[0])).isEqualTo("databasename");
            return true;
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("The database returned a record as expected", new Object[0])).isTrue();
    }

    private void performTestForCharacterEncodingForInitialScriptConnection(HikariDataSource dataSource) throws SQLException {
        boolean result = (Boolean)new QueryRunner((DataSource)dataSource).query("SELECT foo FROM bar WHERE foo LIKE '%\u043c\u0438\u0440'", rs -> {
            rs.next();
            String resultSetString = rs.getString(1);
            ((AbstractStringAssert)Assertions.assertThat((String)resultSetString).as("A basic SELECT query succeeds where the schema has been applied from a script", new Object[0])).isEqualTo("\u043f\u0440\u0438\u0432\u0435\u0442 \u043c\u0438\u0440");
            return true;
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("The database returned a record as expected", new Object[0])).isTrue();
    }

    private void performSimpleTestWithCharacterSet(String jdbcUrl) throws SQLException {
        HikariDataSource datasource1 = this.verifyCharacterSet(jdbcUrl);
        HikariDataSource datasource2 = this.verifyCharacterSet(jdbcUrl);
        datasource1.close();
        datasource2.close();
    }

    private HikariDataSource verifyCharacterSet(String jdbcUrl) throws SQLException {
        HikariDataSource dataSource = this.getDataSource(jdbcUrl, 1);
        boolean result = (Boolean)new QueryRunner((DataSource)dataSource).query("SHOW VARIABLES LIKE 'character\\_set\\_connection'", rs -> {
            rs.next();
            String resultSetString = rs.getString(2);
            ((AbstractStringAssert)Assertions.assertThat((String)resultSetString).as("Passing query parameters to set DB connection encoding is successful", new Object[0])).startsWith((CharSequence)"utf8");
            return true;
        });
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("The database returned a record as expected", new Object[0])).isTrue();
        return dataSource;
    }

    private void performTestForCustomIniFile(HikariDataSource dataSource) throws SQLException {
        Assumptions.assumeThat((boolean)SystemUtils.IS_OS_WINDOWS).isFalse();
        Statement statement = dataSource.getConnection().createStatement();
        statement.execute("SELECT @@GLOBAL.innodb_max_undo_log_size");
        ResultSet resultSet = statement.getResultSet();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resultSet.next()).as("The query returns a result", new Object[0])).isTrue();
        long result = resultSet.getLong(1);
        ((AbstractLongAssert)Assertions.assertThat((long)result).as("The InnoDB max undo log size has been set by the ini file content", new Object[0])).isEqualTo(20000000L);
    }

    private HikariDataSource getDataSource(String jdbcUrl, int poolSize) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setConnectionTestQuery("SELECT 1");
        hikariConfig.setMinimumIdle(1);
        hikariConfig.setMaximumPoolSize(poolSize);
        return new HikariDataSource(hikariConfig);
    }

    protected static enum Options {
        ScriptedSchema,
        CharacterSet,
        CustomIniFile,
        JDBCParams,
        PmdKnownBroken;

    }
}

