/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okhttp3.internal.tls;

import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.kotlin.jvm.internal.SourceDebugExtension;
import org.testcontainers.shaded.okhttp3.internal.tls.TrustRootIndex;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/testcontainers/shaded/okhttp3/internal/tls/BasicTrustRootIndex;", "Lorg/testcontainers/shaded/okhttp3/internal/tls/TrustRootIndex;", "caCerts", "", "Ljava/security/cert/X509Certificate;", "<init>", "([Ljava/security/cert/X509Certificate;)V", "subjectToCaCerts", "", "Ljavax/security/auth/x500/X500Principal;", "", "findByIssuerAndSignature", "cert", "equals", "", "other", "", "hashCode", "", "okhttp"})
@SourceDebugExtension(value={"SMAP\nBasicTrustRootIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicTrustRootIndex.kt\nokhttp3/internal/tls/BasicTrustRootIndex\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n382#2,7:56\n295#3,2:63\n*S KotlinDebug\n*F\n+ 1 BasicTrustRootIndex.kt\nokhttp3/internal/tls/BasicTrustRootIndex\n*L\n30#1:56,7\n39#1:63,2\n*E\n"})
public final class BasicTrustRootIndex
implements TrustRootIndex {
    @NotNull
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts;

    /*
     * WARNING - void declaration
     */
    public BasicTrustRootIndex(X509Certificate ... caCerts) {
        Intrinsics.checkNotNullParameter(caCerts, "caCerts");
        Map map = new LinkedHashMap();
        for (X509Certificate caCert : caCerts) {
            Object object;
            void $this$getOrPut$iv;
            Map map2 = map;
            X500Principal key$iv = caCert.getSubjectX500Principal();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(caCert);
        }
        this.subjectToCaCerts = map;
    }

    @Override
    @Nullable
    public X509Certificate findByIssuerAndSignature(@NotNull X509Certificate cert) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter(cert, "cert");
            X500Principal issuer = cert.getIssuerX500Principal();
            Set<X509Certificate> set = this.subjectToCaCerts.get(issuer);
            if (set == null) {
                return null;
            }
            Set<X509Certificate> subjectCaCerts = set;
            Iterable $this$firstOrNull$iv = subjectCaCerts;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                X509Certificate it = (X509Certificate)element$iv;
                boolean bl2 = false;
                try {
                    cert.verify(it.getPublicKey());
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (!bl) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof BasicTrustRootIndex && Intrinsics.areEqual(((BasicTrustRootIndex)other).subjectToCaCerts, this.subjectToCaCerts);
    }

    public int hashCode() {
        return ((Object)this.subjectToCaCerts).hashCode();
    }
}

