/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.lang.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.com.google.common.base.Charsets;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.PathUtils;

public class MountableFile
implements Transferable {
    private static final Logger log = LoggerFactory.getLogger(MountableFile.class);
    private final String path;
    private final AtomicReference<Object> resolvedPath = new AtomicReference();

    public static MountableFile forClasspathResource(@NotNull String resourceName) {
        return new MountableFile(MountableFile.getClasspathResource(resourceName, new HashSet<ClassLoader>()).toString());
    }

    public static MountableFile forHostPath(@NotNull String path) {
        return new MountableFile(new File(path).toURI().toString());
    }

    public static MountableFile forHostPath(Path path) {
        return new MountableFile(path.toAbsolutePath().toString());
    }

    @NotNull
    private static URL getClasspathResource(@NotNull String resourcePath, @NotNull Set<ClassLoader> classLoaders) {
        HashSet<ClassLoader> classLoadersToSearch = new HashSet<ClassLoader>(classLoaders);
        classLoadersToSearch.add(Thread.currentThread().getContextClassLoader());
        classLoadersToSearch.add(ClassLoader.getSystemClassLoader());
        classLoadersToSearch.add(MountableFile.class.getClassLoader());
        for (ClassLoader classLoader : classLoadersToSearch) {
            URL resource = classLoader.getResource(resourcePath);
            if (resource != null) {
                return resource;
            }
            if (!resourcePath.startsWith("/") || (resource = classLoader.getResource(resourcePath.replaceFirst("/", ""))) == null) continue;
            return resource;
        }
        throw new IllegalArgumentException("Resource with path " + resourcePath + " could not be found on any of these classloaders: " + classLoadersToSearch);
    }

    private static String unencodeResourceURIToFilePath(@NotNull String resource) {
        try {
            return URLDecoder.decode(resource, Charsets.UTF_8.name()).replaceFirst("jar:", "").replaceFirst("file:", "").replaceAll("!.*", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private String resolvePath() {
        String result = this.path.contains(".jar!") ? this.extractClassPathResourceToTempLocation(this.path) : MountableFile.unencodeResourceURIToFilePath(this.path);
        if (SystemUtils.IS_OS_WINDOWS) {
            result = PathUtils.createMinGWPath(result);
        }
        return result;
    }

    private String extractClassPathResourceToTempLocation(String hostPath) {
        File tmpLocation = new File(".testcontainers-tmp-" + Base58.randomString(5));
        tmpLocation.delete();
        String urldecodedJarPath = MountableFile.unencodeResourceURIToFilePath(hostPath);
        String internalPath = hostPath.replaceAll("[^!]*!/", "");
        try (JarFile jarFile = new JarFile(urldecodedJarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(internalPath)) continue;
                log.debug("Copying classpath resource(s) from {} to {} to permit Docker to bind", (Object)hostPath, (Object)tmpLocation);
                this.copyFromJarToLocation(jarFile, entry, internalPath, tmpLocation);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to process JAR file when extracting classpath resource: " + hostPath, e);
        }
        this.deleteOnExit(tmpLocation.toPath());
        return tmpLocation.getAbsolutePath();
    }

    private void copyFromJarToLocation(JarFile jarFile, JarEntry entry, String fromRoot, File toRoot) throws IOException {
        String destinationName = entry.getName().replaceFirst(fromRoot, "");
        File newFile = new File(toRoot, destinationName);
        log.debug("Copying resource {} from JAR file {}", (Object)fromRoot, (Object)jarFile.getName());
        if (!entry.isDirectory()) {
            newFile.mkdirs();
            newFile.delete();
            newFile.deleteOnExit();
            try (InputStream is = jarFile.getInputStream(entry);){
                Files.copy(is, newFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("Failed to extract classpath resource " + entry.getName() + " from JAR file " + jarFile.getName(), e);
                throw e;
            }
        }
    }

    private void deleteOnExit(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PathUtils.recursiveDeleteDir(path)));
    }

    @Override
    public void transferTo(TarArchiveOutputStream outputStream, String destinationPathInTar) {
        this.recursiveTar(destinationPathInTar, this.getResolvedPath(), this.getResolvedPath(), outputStream);
    }

    private void recursiveTar(String destination, String sourceRootDir, String sourceCurrentItem, TarArchiveOutputStream tarArchive) {
        try {
            File sourceFile = new File(sourceCurrentItem).getCanonicalFile();
            File sourceRootFile = new File(sourceRootDir).getCanonicalFile();
            String relativePathToSourceFile = sourceRootFile.toPath().relativize(sourceFile.toPath()).toFile().toString();
            TarArchiveEntry tarEntry = new TarArchiveEntry(sourceFile, destination + "/" + relativePathToSourceFile);
            tarEntry.setMode(this.getUnixFileMode(sourceCurrentItem));
            tarArchive.putArchiveEntry(tarEntry);
            if (sourceFile.isFile()) {
                Files.copy(sourceFile.toPath(), tarArchive);
            }
            tarArchive.closeArchiveEntry();
            File[] children = sourceFile.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.recursiveTar(destination, sourceRootDir + File.separator, child.getCanonicalPath(), tarArchive);
                }
            }
        }
        catch (IOException e) {
            log.error("Error when copying TAR file entry: {}", (Object)sourceCurrentItem, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getSize() {
        File file = new File(this.getResolvedPath());
        if (file.isFile()) {
            return file.length();
        }
        return 0L;
    }

    @Override
    public String getDescription() {
        return this.getResolvedPath();
    }

    @Override
    public int getFileMode() {
        return this.getUnixFileMode(this.getResolvedPath());
    }

    private int getUnixFileMode(String pathAsString) {
        Path path = Paths.get(pathAsString, new String[0]);
        try {
            return (Integer)Files.getAttribute(path, "unix:mode", new LinkOption[0]);
        }
        catch (IOException e) {
            int mode = 33188;
            if (Files.isDirectory(path, new LinkOption[0])) {
                mode = 16877;
            } else if (Files.isExecutable(path)) {
                mode |= 0x49;
            }
            return mode;
        }
    }

    MountableFile(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResolvedPath() {
        Object value = this.resolvedPath.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.resolvedPath;
            synchronized (atomicReference) {
                value = this.resolvedPath.get();
                if (value == null) {
                    String actualValue = this.resolvePath();
                    value = actualValue == null ? this.resolvedPath : actualValue;
                    this.resolvedPath.set(value);
                }
            }
        }
        return (String)(value == this.resolvedPath ? null : value);
    }
}

