/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.core.DockerClientConfig;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.dockerclient.LogToStringContainerCallback;

public class DockerClientConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(DockerClientConfigUtils.class);
    public static final boolean IN_A_CONTAINER = new File("/.dockerenv").exists();
    private static final AtomicReference<Object> detectedDockerHostIp = new AtomicReference();

    public static String getDockerHostIpAddress(DockerClientConfig config) {
        return DockerClientConfigUtils.getDetectedDockerHostIp().orElseGet(() -> {
            switch (config.getDockerHost().getScheme()) {
                case "http": 
                case "https": 
                case "tcp": {
                    return config.getDockerHost().getHost();
                }
                case "unix": {
                    return "localhost";
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> getDetectedDockerHostIp() {
        Object value = detectedDockerHostIp.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = detectedDockerHostIp;
            synchronized (atomicReference) {
                value = detectedDockerHostIp.get();
                if (value == null) {
                    Optional<String> actualValue = Optional.of(IN_A_CONTAINER).filter(it -> it).map(file -> DockerClientFactory.instance().runInsideDocker(cmd -> cmd.withCmd("sh", "-c", "ip route|awk '/default/ { print $3 }'"), (client, id) -> {
                        try {
                            return client.logContainerCmd((String)id).withStdOut(true).exec(new LogToStringContainerCallback()).toString();
                        }
                        catch (Exception e) {
                            log.warn("Can't parse the default gateway IP", e);
                            return null;
                        }
                    })).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank);
                    value = actualValue == null ? detectedDockerHostIp : actualValue;
                    detectedDockerHostIp.set(value);
                }
            }
        }
        return (Optional)(value == detectedDockerHostIp ? null : value);
    }
}

