/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder.dockerfile.statement;

import java.util.Arrays;
import org.testcontainers.images.builder.dockerfile.statement.Statement;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public class MultiArgsStatement
extends Statement {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected final String[] args;

    public MultiArgsStatement(String type, String ... args) {
        super(type);
        this.args = args;
    }

    @Override
    public void appendArguments(StringBuilder dockerfileStringBuilder) {
        try {
            dockerfileStringBuilder.append(objectMapper.writeValueAsString(this.args));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Can't serialize arguments: " + Arrays.toString(this.args), e);
        }
    }
}

