/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import org.testcontainers.shaded.com.github.dockerjava.api.model.Frame;
import org.testcontainers.shaded.com.github.dockerjava.api.model.StreamType;
import org.testcontainers.shaded.com.google.common.base.Charsets;

public class OutputFrame {
    public static final OutputFrame END = new OutputFrame(OutputType.END, null);
    private final OutputType type;
    private final byte[] bytes;

    public OutputFrame(OutputType type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    public OutputType getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getUtf8String() {
        if (this.bytes == null) {
            return null;
        }
        return new String(this.bytes, Charsets.UTF_8);
    }

    public static OutputFrame forFrame(Frame frame) {
        OutputType outputType = OutputType.forStreamType(frame.getStreamType());
        if (outputType == null) {
            return null;
        }
        return new OutputFrame(outputType, frame.getPayload());
    }

    public static enum OutputType {
        STDOUT,
        STDERR,
        END;


        public static OutputType forStreamType(StreamType streamType) {
            switch (streamType) {
                case RAW: {
                    return STDOUT;
                }
                case STDOUT: {
                    return STDOUT;
                }
                case STDERR: {
                    return STDERR;
                }
            }
            return null;
        }
    }
}

