/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.circuitbreakers;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.circuitbreakers.Breaker;
import org.rnorth.ducttape.circuitbreakers.State;
import org.rnorth.ducttape.circuitbreakers.StateStore;
import org.rnorth.ducttape.circuitbreakers.TimeSource;

class DefaultBreaker
implements Breaker {
    private final TimeSource timeSource;
    private final long autoResetInterval;
    private final TimeUnit autoResetUnit;
    private final StateStore stateStore;

    DefaultBreaker(@NotNull TimeSource timeSource, long autoResetInterval, @NotNull TimeUnit autoResetUnit, @NotNull StateStore stateStore) {
        this.timeSource = timeSource;
        this.autoResetInterval = autoResetInterval;
        this.autoResetUnit = autoResetUnit;
        this.stateStore = stateStore;
    }

    @Override
    public void tryDo(@NotNull Runnable tryIfAlive, @NotNull Runnable runOnFirstFailure, @NotNull Runnable runIfBroken) {
        if (this.isBroken()) {
            runIfBroken.run();
        } else {
            try {
                tryIfAlive.run();
                this.setState(State.OK);
            }
            catch (Exception e) {
                this.setState(State.BROKEN);
                this.setLastFailure(this.timeSource.getTimeMillis());
                runOnFirstFailure.run();
                runIfBroken.run();
            }
        }
    }

    @Override
    public void tryDo(@NotNull Runnable tryIfAlive, @NotNull Runnable runIfBroken) {
        this.tryDo(tryIfAlive, Breaker::NoOp, runIfBroken);
    }

    @Override
    public void tryDo(@NotNull Runnable tryIfAlive) {
        this.tryDo(tryIfAlive, Breaker::NoOp, Breaker::NoOp);
    }

    @Override
    public <T> T tryGet(@NotNull Callable<T> tryIfAlive, @NotNull Runnable runOnFirstFailure, @NotNull Supplier<T> getIfBroken) {
        if (this.isBroken()) {
            return getIfBroken.get();
        }
        try {
            T callResult = tryIfAlive.call();
            this.setState(State.OK);
            return callResult;
        }
        catch (Exception e) {
            this.setState(State.BROKEN);
            this.setLastFailure(this.timeSource.getTimeMillis());
            runOnFirstFailure.run();
            return getIfBroken.get();
        }
    }

    @Override
    public <T> T tryGet(@NotNull Callable<T> tryIfAlive, @NotNull Supplier<T> getIfBroken) {
        return this.tryGet(tryIfAlive, Breaker::NoOp, getIfBroken);
    }

    @Override
    public <T> Optional<T> tryGet(@NotNull Callable<T> tryIfAlive) {
        return Optional.ofNullable(this.tryGet(tryIfAlive, Breaker::NoOp, () -> null));
    }

    @Override
    public State getState() {
        return this.stateStore.getState();
    }

    private boolean isBroken() {
        boolean broken = this.stateStore.getState() == State.BROKEN;
        boolean notAutoResetYet = this.timeSource.getTimeMillis() - this.autoResetUnit.toMillis(this.autoResetInterval) < this.stateStore.getLastFailure();
        return broken && notAutoResetYet;
    }

    private void setState(@NotNull State state) {
        this.stateStore.setState(state);
    }

    private void setLastFailure(long lastFailure) {
        this.stateStore.setLastFailure(lastFailure);
    }
}

