/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.channel.epoll;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.testcontainers.shaded.io.netty.channel.Channel;
import org.testcontainers.shaded.io.netty.channel.EventLoop;
import org.testcontainers.shaded.io.netty.channel.epoll.AbstractEpollServerChannel;
import org.testcontainers.shaded.io.netty.channel.epoll.EpollEventLoop;
import org.testcontainers.shaded.io.netty.channel.epoll.EpollServerSocketChannelConfig;
import org.testcontainers.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.testcontainers.shaded.io.netty.channel.epoll.Native;
import org.testcontainers.shaded.io.netty.channel.epoll.TcpMd5Util;
import org.testcontainers.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.testcontainers.shaded.io.netty.channel.unix.FileDescriptor;
import org.testcontainers.shaded.io.netty.channel.unix.NativeInetAddress;
import org.testcontainers.shaded.io.netty.channel.unix.Socket;

public final class EpollServerSocketChannel
extends AbstractEpollServerChannel
implements ServerSocketChannel {
    private final EpollServerSocketChannelConfig config;
    private volatile InetSocketAddress local;
    private volatile Collection<InetAddress> tcpMd5SigAddresses = Collections.emptyList();

    public EpollServerSocketChannel() {
        super(Socket.newSocketStream(), false);
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Deprecated
    public EpollServerSocketChannel(FileDescriptor fd) {
        this(new Socket(fd.intValue()));
    }

    @Deprecated
    public EpollServerSocketChannel(Socket fd) {
        super(fd);
        this.local = fd.localAddress();
        this.config = new EpollServerSocketChannelConfig(this);
    }

    public EpollServerSocketChannel(Socket fd, boolean active) {
        super(fd, active);
        this.local = fd.localAddress();
        this.config = new EpollServerSocketChannelConfig(this);
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EpollEventLoop;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        InetSocketAddress addr = (InetSocketAddress)localAddress;
        EpollServerSocketChannel.checkResolvable(addr);
        this.fd().bind(addr);
        this.local = this.fd().localAddress();
        if (Native.IS_SUPPORTING_TCP_FASTOPEN && this.config.getTcpFastopen() > 0) {
            Native.setTcpFastopen(this.fd().intValue(), this.config.getTcpFastopen());
        }
        this.fd().listen(this.config.getBacklog());
        this.active = true;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public EpollServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected InetSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected Channel newChildChannel(int fd, byte[] address, int offset, int len) throws Exception {
        return new EpollSocketChannel(this, new Socket(fd), NativeInetAddress.address(address, offset, len));
    }

    Collection<InetAddress> tcpMd5SigAddresses() {
        return this.tcpMd5SigAddresses;
    }

    void setTcpMd5Sig(Map<InetAddress, byte[]> keys) throws IOException {
        this.tcpMd5SigAddresses = TcpMd5Util.newTcpMd5Sigs(this, this.tcpMd5SigAddresses, keys);
    }
}

