/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.netty.handler;

import java.io.IOException;
import java.io.InputStream;
import org.testcontainers.shaded.com.github.dockerjava.api.async.ResultCallback;
import org.testcontainers.shaded.io.netty.buffer.ByteBuf;
import org.testcontainers.shaded.io.netty.channel.ChannelHandlerContext;
import org.testcontainers.shaded.io.netty.channel.SimpleChannelInboundHandler;

public class HttpResponseStreamHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private ResultCallback<InputStream> resultCallback;
    private final HttpResponseInputStream stream = new HttpResponseInputStream();

    public HttpResponseStreamHandler(ResultCallback<InputStream> resultCallback) {
        this.resultCallback = resultCallback;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.invokeCallbackOnFirstRead();
        this.stream.write(msg.copy());
    }

    private void invokeCallbackOnFirstRead() {
        if (this.resultCallback != null) {
            this.resultCallback.onNext(this.stream);
            this.resultCallback = null;
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.stream.writeComplete();
        super.channelInactive(ctx);
    }

    public static class HttpResponseInputStream
    extends InputStream {
        private boolean writeCompleted = false;
        private boolean closed = false;
        private ByteBuf current = null;
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ByteBuf byteBuf) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                while (this.current != null) {
                    this.lock.wait();
                    if (!this.closed) continue;
                    return;
                }
                this.current = byteBuf;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeComplete() {
            Object object = this.lock;
            synchronized (object) {
                this.writeCompleted = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.closed = true;
                this.releaseCurrent();
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.poll(0);
                return this.readableBytes();
            }
        }

        private int readableBytes() {
            if (this.current != null) {
                return this.current.readableBytes();
            }
            return 0;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            return n != -1 ? b[0] : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                off = this.poll(off);
                if (this.current == null) {
                    return -1;
                }
                int availableBytes = Math.min(len, this.current.readableBytes() - off);
                this.current.readBytes(b, off, availableBytes);
                return availableBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int poll(int off) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                while (this.readableBytes() <= off) {
                    try {
                        if (this.closed) {
                            throw new IOException("Stream closed");
                        }
                        off -= this.releaseCurrent();
                        if (this.writeCompleted) {
                            return off;
                        }
                        while (this.current == null) {
                            this.lock.wait();
                            if (this.closed) {
                                throw new IOException("Stream closed");
                            }
                            if (!this.writeCompleted || this.current != null) continue;
                            return off;
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return off;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int releaseCurrent() {
            Object object = this.lock;
            synchronized (object) {
                if (this.current != null) {
                    int n = this.current.readableBytes();
                    this.current.release();
                    this.current = null;
                    this.lock.notifyAll();
                    return n;
                }
                return 0;
            }
        }
    }
}

