/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.AuthConfigFile;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.NameParser;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class DefaultDockerClientConfig
implements Serializable,
DockerClientConfig {
    private static final long serialVersionUID = 1L;
    public static final String DOCKER_HOST = "DOCKER_HOST";
    public static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    public static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String API_VERSION = "api.version";
    public static final String REGISTRY_USERNAME = "registry.username";
    public static final String REGISTRY_PASSWORD = "registry.password";
    public static final String REGISTRY_EMAIL = "registry.email";
    public static final String REGISTRY_URL = "registry.url";
    private static final String DOCKER_JAVA_PROPERTIES = "docker-java.properties";
    private static final String DOCKER_CFG = ".dockercfg";
    private static final String CONFIG_JSON = "config.json";
    private static final Set<String> CONFIG_KEYS = new HashSet<String>();
    private final URI dockerHost;
    private final String registryUsername;
    private final String registryPassword;
    private final String registryEmail;
    private final String registryUrl;
    private final String dockerConfig;
    private final SSLConfig sslConfig;
    private final RemoteApiVersion apiVersion;

    DefaultDockerClientConfig(URI dockerHost, String dockerConfig, String apiVersion, String registryUrl, String registryUsername, String registryPassword, String registryEmail, SSLConfig sslConfig) {
        this.dockerHost = this.checkDockerHostScheme(dockerHost);
        this.dockerConfig = dockerConfig;
        this.apiVersion = RemoteApiVersion.parseConfigWithDefault(apiVersion);
        this.sslConfig = sslConfig;
        this.registryUsername = registryUsername;
        this.registryPassword = registryPassword;
        this.registryEmail = registryEmail;
        this.registryUrl = registryUrl;
    }

    private URI checkDockerHostScheme(URI dockerHost) {
        if ("tcp".equals(dockerHost.getScheme()) || "unix".equals(dockerHost.getScheme())) {
            return dockerHost;
        }
        throw new DockerClientException("Unsupported protocol scheme found: '" + dockerHost + "'. Only 'tcp://' or 'unix://' supported.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadIncludedDockerProperties(Properties systemProperties) {
        try (InputStream is = DefaultDockerClientConfig.class.getResourceAsStream("/docker-java.properties");){
            Properties p = new Properties();
            p.load(is);
            DefaultDockerClientConfig.replaceProperties(p, systemProperties);
            Properties properties = p;
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void replaceProperties(Properties properties, Properties replacements) {
        for (Object objectKey : properties.keySet()) {
            String key = objectKey.toString();
            properties.setProperty(key, DefaultDockerClientConfig.replaceProperties(properties.getProperty(key), replacements));
        }
    }

    private static String replaceProperties(String s, Properties replacements) {
        for (Map.Entry<Object, Object> entry : replacements.entrySet()) {
            String key = "${" + entry.getKey() + "}";
            while (s.contains(key)) {
                s = s.replace(key, String.valueOf(entry.getValue()));
            }
        }
        return s;
    }

    private static Properties overrideDockerPropertiesWithSettingsFromUserHome(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        File usersDockerPropertiesFile = new File(systemProperties.getProperty("user.home"), ".docker-java.properties");
        if (usersDockerPropertiesFile.isFile()) {
            try (FileInputStream in = new FileInputStream(usersDockerPropertiesFile);){
                overriddenProperties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithEnv(Properties properties, Map<String, String> env) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)properties);
        if (env.containsKey(DOCKER_HOST)) {
            overriddenProperties.setProperty(DOCKER_HOST, env.get(DOCKER_HOST));
        }
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            String envKey = envEntry.getKey();
            if (!CONFIG_KEYS.contains(envKey)) continue;
            overriddenProperties.setProperty(envKey, envEntry.getValue());
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithSystemProperties(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        for (String key : CONFIG_KEYS) {
            if (!systemProperties.containsKey(key)) continue;
            overriddenProperties.setProperty(key, systemProperties.getProperty(key));
        }
        return overriddenProperties;
    }

    public static Builder createDefaultConfigBuilder() {
        return DefaultDockerClientConfig.createDefaultConfigBuilder(System.getenv(), (Properties)System.getProperties().clone());
    }

    static Builder createDefaultConfigBuilder(Map<String, String> env, Properties systemProperties) {
        Properties properties = DefaultDockerClientConfig.loadIncludedDockerProperties(systemProperties);
        properties = DefaultDockerClientConfig.overrideDockerPropertiesWithSettingsFromUserHome(properties, systemProperties);
        properties = DefaultDockerClientConfig.overrideDockerPropertiesWithEnv(properties, env);
        properties = DefaultDockerClientConfig.overrideDockerPropertiesWithSystemProperties(properties, systemProperties);
        return new Builder().withProperties(properties);
    }

    @Override
    public URI getDockerHost() {
        return this.dockerHost;
    }

    @Override
    public RemoteApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getRegistryUsername() {
        return this.registryUsername;
    }

    @Override
    public String getRegistryPassword() {
        return this.registryPassword;
    }

    @Override
    public String getRegistryEmail() {
        return this.registryEmail;
    }

    @Override
    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getDockerConfig() {
        return this.dockerConfig;
    }

    private AuthConfig getAuthConfig() {
        AuthConfig authConfig = null;
        if (this.getRegistryUsername() != null && this.getRegistryPassword() != null && this.getRegistryEmail() != null && this.getRegistryUrl() != null) {
            authConfig = new AuthConfig().withUsername(this.getRegistryUsername()).withPassword(this.getRegistryPassword()).withEmail(this.getRegistryEmail()).withRegistryAddress(this.getRegistryUrl());
        }
        return authConfig;
    }

    @Override
    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig otherAuthConfig;
        AuthConfig authConfig = null;
        File dockerCfgFile = this.getDockerConfigFile();
        if (dockerCfgFile != null) {
            AuthConfigFile authConfigFile;
            try {
                authConfigFile = AuthConfigFile.loadConfig(dockerCfgFile);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile", e);
            }
            NameParser.ReposTag reposTag = NameParser.parseRepositoryTag(imageName);
            NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName(reposTag.repos);
            authConfig = authConfigFile.resolveAuthConfig(hostnameReposName.hostname);
        }
        if ((otherAuthConfig = this.getAuthConfig()) != null) {
            authConfig = otherAuthConfig;
        }
        return authConfig;
    }

    @Override
    public AuthConfigurations getAuthConfigurations() {
        File dockerCfgFile = this.getDockerConfigFile();
        if (dockerCfgFile != null) {
            AuthConfigFile authConfigFile;
            try {
                authConfigFile = AuthConfigFile.loadConfig(dockerCfgFile);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse dockerCfgFile: " + dockerCfgFile.getAbsolutePath(), e);
            }
            return authConfigFile.getAuthConfigurations();
        }
        return new AuthConfigurations();
    }

    private File getDockerConfigFile() {
        Path configJson = Paths.get(this.getDockerConfig(), CONFIG_JSON);
        Path dockerCfg = Paths.get(this.getDockerConfig(), DOCKER_CFG);
        if (Files.exists(configJson, new LinkOption[0])) {
            return configJson.toFile();
        }
        if (Files.exists(dockerCfg, new LinkOption[0])) {
            return dockerCfg.toFile();
        }
        return null;
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static {
        CONFIG_KEYS.add(DOCKER_HOST);
        CONFIG_KEYS.add(DOCKER_TLS_VERIFY);
        CONFIG_KEYS.add(DOCKER_CONFIG);
        CONFIG_KEYS.add(DOCKER_CERT_PATH);
        CONFIG_KEYS.add(API_VERSION);
        CONFIG_KEYS.add(REGISTRY_USERNAME);
        CONFIG_KEYS.add(REGISTRY_PASSWORD);
        CONFIG_KEYS.add(REGISTRY_EMAIL);
        CONFIG_KEYS.add(REGISTRY_URL);
    }

    public static class Builder {
        private URI dockerHost;
        private String apiVersion;
        private String registryUsername;
        private String registryPassword;
        private String registryEmail;
        private String registryUrl;
        private String dockerConfig;
        private String dockerCertPath;
        private Boolean dockerTlsVerify;
        private SSLConfig customSslConfig = null;

        public Builder withProperties(Properties p) {
            return this.withDockerHost(p.getProperty(DefaultDockerClientConfig.DOCKER_HOST)).withDockerTlsVerify(p.getProperty(DefaultDockerClientConfig.DOCKER_TLS_VERIFY)).withDockerConfig(p.getProperty(DefaultDockerClientConfig.DOCKER_CONFIG)).withDockerCertPath(p.getProperty(DefaultDockerClientConfig.DOCKER_CERT_PATH)).withApiVersion(p.getProperty(DefaultDockerClientConfig.API_VERSION)).withRegistryUsername(p.getProperty(DefaultDockerClientConfig.REGISTRY_USERNAME)).withRegistryPassword(p.getProperty(DefaultDockerClientConfig.REGISTRY_PASSWORD)).withRegistryEmail(p.getProperty(DefaultDockerClientConfig.REGISTRY_EMAIL)).withRegistryUrl(p.getProperty(DefaultDockerClientConfig.REGISTRY_URL));
        }

        public final Builder withDockerHost(String dockerHost) {
            Preconditions.checkNotNull(dockerHost, "uri was not specified");
            this.dockerHost = URI.create(dockerHost);
            return this;
        }

        public final Builder withApiVersion(RemoteApiVersion apiVersion) {
            this.apiVersion = apiVersion.getVersion();
            return this;
        }

        public final Builder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public final Builder withRegistryUsername(String registryUsername) {
            this.registryUsername = registryUsername;
            return this;
        }

        public final Builder withRegistryPassword(String registryPassword) {
            this.registryPassword = registryPassword;
            return this;
        }

        public final Builder withRegistryEmail(String registryEmail) {
            this.registryEmail = registryEmail;
            return this;
        }

        public Builder withRegistryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this;
        }

        public final Builder withDockerCertPath(String dockerCertPath) {
            this.dockerCertPath = dockerCertPath;
            return this;
        }

        public final Builder withDockerConfig(String dockerConfig) {
            this.dockerConfig = dockerConfig;
            return this;
        }

        public final Builder withDockerTlsVerify(String dockerTlsVerify) {
            String trimmed;
            this.dockerTlsVerify = dockerTlsVerify != null ? Boolean.valueOf("true".equalsIgnoreCase(trimmed = dockerTlsVerify.trim()) || "1".equals(trimmed)) : Boolean.valueOf(false);
            return this;
        }

        public final Builder withDockerTlsVerify(Boolean dockerTlsVerify) {
            this.dockerTlsVerify = dockerTlsVerify;
            return this;
        }

        public final Builder withCustomSslConfig(SSLConfig customSslConfig) {
            this.customSslConfig = customSslConfig;
            return this;
        }

        public DefaultDockerClientConfig build() {
            SSLConfig sslConfig = null;
            if (this.customSslConfig == null) {
                if (BooleanUtils.isTrue(this.dockerTlsVerify)) {
                    this.dockerCertPath = this.checkDockerCertPath(this.dockerCertPath);
                    sslConfig = new LocalDirectorySSLConfig(this.dockerCertPath);
                }
            } else {
                sslConfig = this.customSslConfig;
            }
            return new DefaultDockerClientConfig(this.dockerHost, this.dockerConfig, this.apiVersion, this.registryUrl, this.registryUsername, this.registryPassword, this.registryEmail, sslConfig);
        }

        private String checkDockerCertPath(String dockerCertPath) {
            if (StringUtils.isEmpty(dockerCertPath)) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certifate path (DOCKER_CERT_PATH) is not defined.");
            }
            File certPath = new File(dockerCertPath);
            if (!certPath.exists()) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) '" + dockerCertPath + "' doesn't exist.");
            }
            if (!certPath.isDirectory()) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) '" + dockerCertPath + "' doesn't point to a directory.");
            }
            return dockerCertPath;
        }
    }
}

