/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jvnet.hk2.internal;

import java.net.URL;
import org.testcontainers.shaded.org.glassfish.hk2.utilities.reflection.Pretty;

class DelegatingClassLoader<T>
extends ClassLoader {
    private final ClassLoader[] delegates;

    DelegatingClassLoader(ClassLoader parent, ClassLoader ... classLoaderDelegates) {
        super(parent);
        this.delegates = classLoaderDelegates;
    }

    @Override
    public Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.getParent() != null) {
            try {
                return this.getParent().loadClass(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        ClassNotFoundException firstFail = null;
        for (ClassLoader delegate : this.delegates) {
            try {
                return delegate.loadClass(clazz);
            }
            catch (ClassNotFoundException ncfe) {
                if (firstFail != null) continue;
                firstFail = ncfe;
            }
        }
        if (firstFail != null) {
            throw firstFail;
        }
        throw new ClassNotFoundException("Could not find " + clazz);
    }

    @Override
    public URL getResource(String resource) {
        URL u;
        if (this.getParent() != null && (u = this.getParent().getResource(resource)) != null) {
            return u;
        }
        for (ClassLoader delegate : this.delegates) {
            URL u2 = delegate.getResource(resource);
            if (u2 == null) continue;
            return u2;
        }
        return null;
    }

    public int hashCode() {
        int code = this.getParent() == null ? 0 : this.getParent().hashCode();
        for (ClassLoader delegate : this.delegates) {
            code ^= delegate.hashCode();
        }
        return code;
    }

    private static final boolean safeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DelegatingClassLoader)) {
            return false;
        }
        DelegatingClassLoader other = (DelegatingClassLoader)o;
        if (!DelegatingClassLoader.safeEquals(this.getParent(), other.getParent())) {
            return false;
        }
        if (this.delegates.length != other.delegates.length) {
            return false;
        }
        for (int lcv = 0; lcv < this.delegates.length; ++lcv) {
            if (DelegatingClassLoader.safeEquals(this.delegates[lcv], other.delegates[lcv])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "DelegatingClassLoader(" + this.getParent() + "," + Pretty.array(this.delegates) + "," + System.identityHashCode(this) + ")";
    }
}

