/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jvnet.hk2.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.ProxyFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.testcontainers.shaded.org.glassfish.hk2.utilities.reflection.Logger;
import org.testcontainers.shaded.org.jvnet.hk2.internal.ClazzCreator;
import org.testcontainers.shaded.org.jvnet.hk2.internal.ConstructorAction;
import org.testcontainers.shaded.org.jvnet.hk2.internal.MethodInterceptorHandler;

final class ConstructorActionImpl<T>
implements ConstructorAction {
    private static final MethodFilter METHOD_FILTER = new MethodFilter(){

        @Override
        public boolean isHandled(Method method) {
            return !method.getName().equals("finalize");
        }
    };
    private final ClazzCreator<T> clazzCreator;
    private final Map<Method, List<MethodInterceptor>> methodInterceptors;

    ConstructorActionImpl(ClazzCreator<T> clazzCreator, Map<Method, List<MethodInterceptor>> methodInterceptors) {
        this.clazzCreator = clazzCreator;
        this.methodInterceptors = methodInterceptors;
    }

    @Override
    public Object makeMe(final Constructor<?> c, final Object[] args, final boolean neutralCCL) throws Throwable {
        final MethodInterceptorHandler methodInterceptor = new MethodInterceptorHandler(this.clazzCreator.locator, this.methodInterceptors);
        final ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(this.clazzCreator.implClass);
        proxyFactory.setFilter(METHOD_FILTER);
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                ClassLoader currentCCL = null;
                if (neutralCCL) {
                    currentCCL = Thread.currentThread().getContextClassLoader();
                }
                try {
                    Object object = proxyFactory.create(c.getParameterTypes(), args, methodInterceptor);
                    return object;
                }
                catch (InvocationTargetException ite) {
                    Throwable targetException = ite.getTargetException();
                    Logger.getLogger().debug(c.getDeclaringClass().getName(), c.getName(), targetException);
                    if (targetException instanceof Exception) {
                        throw (Exception)targetException;
                    }
                    throw new RuntimeException(targetException);
                }
                finally {
                    if (neutralCCL) {
                        Thread.currentThread().setContextClassLoader(currentCCL);
                    }
                }
            }
        });
    }
}

