/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.AbstractTlsClient;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsCipher;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsCipherFactory;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsSRPUtils;
import org.testcontainers.shaded.org.bouncycastle.crypto.tls.TlsUtils;
import org.testcontainers.shaded.org.bouncycastle.util.Arrays;

public abstract class SRPTlsClient
extends AbstractTlsClient {
    public static final Integer EXT_SRP = TlsSRPUtils.EXT_SRP;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] byArray, byte[] byArray2) {
        this.identity = Arrays.clone(byArray);
        this.password = Arrays.clone(byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, byte[] byArray, byte[] byArray2) {
        super(tlsCipherFactory);
        this.identity = Arrays.clone(byArray);
        this.password = Arrays.clone(byArray2);
    }

    public int[] getCipherSuites() {
        return new int[]{49182};
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.identity);
        return hashtable;
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(hashtable, TlsSRPUtils.EXT_SRP, (short)47)) {
            // empty if block
        }
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPKeyExchange(21);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPKeyExchange(23);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPKeyExchange(22);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 49178: 
            case 49179: 
            case 49180: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 49181: 
            case 49182: 
            case 49183: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 49184: 
            case 49185: 
            case 49186: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n) {
        return new TlsSRPKeyExchange(n, this.supportedSignatureAlgorithms, this.identity, this.password);
    }
}

