/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.IndefiniteWaitOneShotStartupCheckStrategy;
import org.testcontainers.shaded.com.google.common.base.Joiner;
import org.testcontainers.shaded.com.google.common.util.concurrent.Uninterruptibles;

class DockerCompose
extends GenericContainer<DockerCompose> {
    public DockerCompose(File composeFile, String identifier) {
        super("dduportal/docker-compose:1.7.1");
        this.addEnv("COMPOSE_PROJECT_NAME", identifier);
        this.addEnv("COMPOSE_FILE", "/compose/" + composeFile.getAbsoluteFile().getName());
        this.addFileSystemBind(composeFile.getAbsoluteFile().getParentFile().getAbsolutePath(), "/compose", BindMode.READ_ONLY);
        this.addFileSystemBind("/var/run/docker.sock", "/docker.sock", BindMode.READ_WRITE);
        this.addEnv("DOCKER_HOST", "unix:///docker.sock");
        this.setStartupCheckStrategy(new IndefiniteWaitOneShotStartupCheckStrategy());
        this.setWorkingDirectory("/compose");
    }

    @Override
    public void start() {
        super.start();
        this.followOutput(new Slf4jLogConsumer(this.logger()), OutputFrame.OutputType.STDERR);
        this.logger().info("Docker compose container is running for command: {}", (Object)Joiner.on(" ").join(this.getCommandParts()));
        while (this.isRunning().booleanValue()) {
            this.logger().trace("Compose container is still running");
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        this.logger().info("Docker compose has finished running");
    }
}

