/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.ratelimits;

import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public abstract class RateLimiter {
    protected long lastInvocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWhenReady(@NotNull Runnable lambda) {
        long waitBeforeNextInvocation = this.getWaitBeforeNextInvocation();
        try {
            Thread.sleep(waitBeforeNextInvocation);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            lambda.run();
        }
        finally {
            this.lastInvocation = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getWhenReady(@NotNull Callable<T> lambda) throws Exception {
        long waitBeforeNextInvocation = this.getWaitBeforeNextInvocation();
        try {
            Thread.sleep(waitBeforeNextInvocation);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            T t = lambda.call();
            return t;
        }
        finally {
            this.lastInvocation = System.currentTimeMillis();
        }
    }

    protected abstract long getWaitBeforeNextInvocation();
}

