/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.shaded.com.github.dockerjava.api.DockerClient;
import org.testcontainers.shaded.com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.DockerException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.InternalServerErrorException;
import org.testcontainers.shaded.com.github.dockerjava.api.exception.NotFoundException;
import org.testcontainers.shaded.com.github.dockerjava.api.model.Network;

public final class ResourceReaper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceReaper.class);
    private static ResourceReaper instance;
    private final DockerClient dockerClient;
    private Map<String, String> registeredContainers = new ConcurrentHashMap<String, String>();
    private List<String> registeredNetworks = new ArrayList<String>();

    private ResourceReaper() {
        this.dockerClient = DockerClientFactory.instance().client();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.registeredContainers.forEach(this::stopContainer);
            this.registeredNetworks.forEach(this::removeNetwork);
        }));
    }

    public static synchronized ResourceReaper instance() {
        if (instance == null) {
            instance = new ResourceReaper();
        }
        return instance;
    }

    public void registerContainerForCleanup(String containerId, String imageName) {
        this.registeredContainers.put(containerId, imageName);
    }

    public void stopAndRemoveContainer(String containerId) {
        this.stopContainer(containerId, this.registeredContainers.get(containerId));
    }

    public void stopAndRemoveContainer(String containerId, String imageName) {
        this.stopContainer(containerId, imageName);
        this.registeredContainers.remove(containerId);
    }

    private void stopContainer(String containerId, String imageName) {
        boolean running;
        try {
            InspectContainerResponse containerInfo = this.dockerClient.inspectContainerCmd(containerId).exec();
            running = containerInfo.getState().getRunning();
        }
        catch (NotFoundException e) {
            LOGGER.trace("Was going to stop container but it apparently no longer exists: {}");
            return;
        }
        catch (DockerException e) {
            LOGGER.trace("Error encountered when checking container for shutdown (ID: {}) - it may not have been stopped, or may already be stopped: {}", (Object)containerId, (Object)e.getMessage());
            return;
        }
        if (running) {
            try {
                LOGGER.trace("Stopping container: {}", (Object)containerId);
                this.dockerClient.killContainerCmd(containerId).exec();
                LOGGER.trace("Stopped container: {}", (Object)imageName);
            }
            catch (DockerException e) {
                LOGGER.trace("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped: {}", (Object)containerId, (Object)e.getMessage());
            }
        }
        try {
            LOGGER.trace("Removing container: {}", (Object)containerId);
            try {
                this.dockerClient.removeContainerCmd(containerId).withRemoveVolumes(true).withForce(true).exec();
                LOGGER.debug("Removed container and associated volume(s): {}", (Object)imageName);
            }
            catch (InternalServerErrorException e) {
                LOGGER.trace("Exception when removing container with associated volume(s): {} (due to {})", (Object)imageName, (Object)e.getMessage());
            }
        }
        catch (DockerException e) {
            LOGGER.trace("Error encountered shutting down container (ID: {}) - it may not have been stopped, or may already be stopped: {}", (Object)containerId, (Object)e.getMessage());
        }
    }

    public void registerNetworkForCleanup(String networkName) {
        this.registeredNetworks.add(networkName);
    }

    private void removeNetwork(String networkName) {
        List networks;
        try {
            networks = (List)this.dockerClient.listNetworksCmd().withNameFilter(networkName).exec();
        }
        catch (DockerException e) {
            LOGGER.trace("Error encountered when looking up network for removal (name: {}) - it may not have been removed", (Object)networkName);
            return;
        }
        for (Network network : networks) {
            try {
                this.dockerClient.removeNetworkCmd(network.getId()).exec();
                LOGGER.debug("Removed network: {}", (Object)networkName);
            }
            catch (DockerException e) {
                LOGGER.trace("Error encountered removing network (name: {}) - it may not have been removed", (Object)network.getName());
            }
        }
    }
}

