/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.glassfish.jersey.client.filter;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.testcontainers.shaded.javax.inject.Inject;
import org.testcontainers.shaded.javax.ws.rs.client.ClientRequestContext;
import org.testcontainers.shaded.javax.ws.rs.client.ClientRequestFilter;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.Sets;
import org.testcontainers.shaded.org.glassfish.hk2.api.ServiceLocator;
import org.testcontainers.shaded.org.glassfish.jersey.client.internal.LocalizationMessages;
import org.testcontainers.shaded.org.glassfish.jersey.spi.ContentEncoder;

public final class EncodingFilter
implements ClientRequestFilter {
    @Inject
    private ServiceLocator serviceLocator;
    private volatile List<Object> supportedEncodings = null;

    @Override
    public void filter(ClientRequestContext request) throws IOException {
        if (this.getSupportedEncodings().isEmpty()) {
            return;
        }
        request.getHeaders().addAll("Accept-Encoding", this.getSupportedEncodings());
        String useEncoding = (String)request.getConfiguration().getProperty("jersey.config.client.useEncoding");
        if (useEncoding != null) {
            if (!this.getSupportedEncodings().contains(useEncoding)) {
                Logger.getLogger(this.getClass().getName()).warning(LocalizationMessages.USE_ENCODING_IGNORED("jersey.config.client.useEncoding", useEncoding, this.getSupportedEncodings()));
            } else if (request.hasEntity() && request.getHeaders().getFirst("Content-Encoding") == null) {
                request.getHeaders().putSingle("Content-Encoding", useEncoding);
            }
        }
    }

    List<Object> getSupportedEncodings() {
        if (this.supportedEncodings == null) {
            TreeSet<String> se = Sets.newTreeSet();
            List<ContentEncoder> encoders = this.serviceLocator.getAllServices(ContentEncoder.class, new Annotation[0]);
            for (ContentEncoder encoder : encoders) {
                se.addAll(encoder.getSupportedEncodings());
            }
            this.supportedEncodings = new ArrayList<Object>(se);
        }
        return this.supportedEncodings;
    }
}

