/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.jersey.repackaged.com.google.common.hash;

import java.io.Serializable;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Preconditions;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.hash.HashCode;

public final class HashCodes {
    public static HashCode fromInt(int hash) {
        return new IntHashCode(hash);
    }

    public static HashCode fromLong(long hash) {
        return new LongHashCode(hash);
    }

    static HashCode fromBytesNoCopy(byte[] bytes) {
        return new BytesHashCode(bytes);
    }

    private static final class BytesHashCode
    extends HashCode
    implements Serializable {
        final byte[] bytes;

        BytesHashCode(byte[] bytes) {
            this.bytes = Preconditions.checkNotNull(bytes);
        }

        @Override
        public byte[] asBytes() {
            return (byte[])this.bytes.clone();
        }

        @Override
        public int asInt() {
            Preconditions.checkState(this.bytes.length >= 4, "HashCode#asInt() requires >= 4 bytes (it only has %s bytes).", this.bytes.length);
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }

        @Override
        public int hashCode() {
            if (this.bytes.length >= 4) {
                return this.asInt();
            }
            int val = this.bytes[0] & 0xFF;
            for (int i = 1; i < this.bytes.length; ++i) {
                val |= (this.bytes[i] & 0xFF) << i * 8;
            }
            return val;
        }
    }

    private static final class LongHashCode
    extends HashCode
    implements Serializable {
        final long hash;

        LongHashCode(long hash) {
            this.hash = hash;
        }

        @Override
        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24), (byte)(this.hash >> 32), (byte)(this.hash >> 40), (byte)(this.hash >> 48), (byte)(this.hash >> 56)};
        }

        @Override
        public int asInt() {
            return (int)this.hash;
        }
    }

    private static final class IntHashCode
    extends HashCode
    implements Serializable {
        final int hash;

        IntHashCode(int hash) {
            this.hash = hash;
        }

        @Override
        public byte[] asBytes() {
            return new byte[]{(byte)this.hash, (byte)(this.hash >> 8), (byte)(this.hash >> 16), (byte)(this.hash >> 24)};
        }

        @Override
        public int asInt() {
            return this.hash;
        }
    }
}

