/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.io.netty.channel.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.testcontainers.shaded.io.netty.buffer.ByteBuf;
import org.testcontainers.shaded.io.netty.buffer.ByteBufAllocator;
import org.testcontainers.shaded.io.netty.channel.Channel;
import org.testcontainers.shaded.io.netty.channel.ChannelConfig;
import org.testcontainers.shaded.io.netty.channel.ChannelOption;
import org.testcontainers.shaded.io.netty.channel.ChannelOutboundBuffer;
import org.testcontainers.shaded.io.netty.channel.ChannelPipeline;
import org.testcontainers.shaded.io.netty.channel.FileRegion;
import org.testcontainers.shaded.io.netty.channel.RecvByteBufAllocator;
import org.testcontainers.shaded.io.netty.channel.nio.AbstractNioChannel;
import org.testcontainers.shaded.io.netty.channel.socket.ChannelInputShutdownEvent;
import org.testcontainers.shaded.io.netty.util.internal.StringUtil;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';
    private Runnable flushTask;

    protected AbstractNioByteChannel(Channel parent, SelectableChannel ch) {
        super(parent, ch, 1);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        boolean setOpWrite;
        block14: {
            int writeSpinCount = -1;
            setOpWrite = false;
            while (true) {
                Object msg;
                if ((msg = in.current()) == null) {
                    this.clearOpWrite();
                    return;
                }
                if (msg instanceof ByteBuf) {
                    ByteBuf buf = (ByteBuf)msg;
                    int readableBytes = buf.readableBytes();
                    if (readableBytes == 0) {
                        in.remove();
                        continue;
                    }
                    boolean done = false;
                    long flushedAmount = 0L;
                    if (writeSpinCount == -1) {
                        writeSpinCount = this.config().getWriteSpinCount();
                    }
                    for (int i = writeSpinCount - 1; i >= 0; --i) {
                        int localFlushedAmount = this.doWriteBytes(buf);
                        if (localFlushedAmount == 0) {
                            setOpWrite = true;
                            break;
                        }
                        flushedAmount += (long)localFlushedAmount;
                        if (buf.isReadable()) continue;
                        done = true;
                        break;
                    }
                    in.progress(flushedAmount);
                    if (done) {
                        in.remove();
                        continue;
                    }
                } else {
                    boolean done;
                    if (!(msg instanceof FileRegion)) break;
                    FileRegion region = (FileRegion)msg;
                    boolean bl = done = region.transfered() >= region.count();
                    if (!done) {
                        long flushedAmount = 0L;
                        if (writeSpinCount == -1) {
                            writeSpinCount = this.config().getWriteSpinCount();
                        }
                        for (int i = writeSpinCount - 1; i >= 0; --i) {
                            long localFlushedAmount = this.doWriteFileRegion(region);
                            if (localFlushedAmount == 0L) {
                                setOpWrite = true;
                                break;
                            }
                            flushedAmount += localFlushedAmount;
                            if (region.transfered() < region.count()) continue;
                            done = true;
                            break;
                        }
                        in.progress(flushedAmount);
                    }
                    if (done) {
                        in.remove();
                        continue;
                    }
                }
                break block14;
                break;
            }
            throw new Error();
        }
        this.incompleteWrite(setOpWrite);
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (buf.isDirect()) {
                return msg;
            }
            return this.newDirectBuffer(buf);
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    protected final void incompleteWrite(boolean setOpWrite) {
        if (setOpWrite) {
            this.setOpWrite();
        } else {
            Runnable flushTask = this.flushTask;
            if (flushTask == null) {
                flushTask = this.flushTask = new Runnable(){

                    @Override
                    public void run() {
                        AbstractNioByteChannel.this.flush();
                    }
                };
            }
            this.eventLoop().execute(flushTask);
        }
    }

    protected abstract long doWriteFileRegion(FileRegion var1) throws Exception;

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1) throws Exception;

    protected final void setOpWrite() {
        SelectionKey key = this.selectionKey();
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & 4) == 0) {
            key.interestOps(interestOps | 4);
        }
    }

    protected final void clearOpWrite() {
        SelectionKey key = this.selectionKey();
        if (!key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & 4) != 0) {
            key.interestOps(interestOps & 0xFFFFFFFB);
        }
    }

    protected class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        protected NioByteUnsafe() {
            super(AbstractNioByteChannel.this);
        }

        private void closeOnRead(ChannelPipeline pipeline) {
            SelectionKey key = AbstractNioByteChannel.this.selectionKey();
            AbstractNioByteChannel.this.setInputShutdown();
            if (AbstractNioByteChannel.this.isOpen()) {
                if (Boolean.TRUE.equals(AbstractNioByteChannel.this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                    key.interestOps(key.interestOps() & ~AbstractNioByteChannel.this.readInterestOp);
                    pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                } else {
                    this.close(this.voidPromise());
                }
            }
        }

        private void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean close, RecvByteBufAllocator.Handle allocHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    AbstractNioByteChannel.this.setReadPending(false);
                    pipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (close || cause instanceof IOException) {
                this.closeOnRead(pipeline);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void read() {
            ChannelConfig config = AbstractNioByteChannel.this.config();
            if (!config.isAutoRead() && !AbstractNioByteChannel.this.isReadPending()) {
                this.removeReadOp();
                return;
            }
            ChannelPipeline pipeline = AbstractNioByteChannel.this.pipeline();
            ByteBufAllocator allocator = config.getAllocator();
            RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            ByteBuf byteBuf = null;
            try {
                boolean needReadPendingReset = true;
                do {
                    byteBuf = allocHandle.allocate(allocator);
                    allocHandle.lastBytesRead(AbstractNioByteChannel.this.doReadBytes(byteBuf));
                    if (allocHandle.lastBytesRead() <= 0) {
                        byteBuf.release();
                        byteBuf = null;
                        break;
                    }
                    allocHandle.incMessagesRead(1);
                    if (needReadPendingReset) {
                        needReadPendingReset = false;
                        AbstractNioByteChannel.this.setReadPending(false);
                    }
                    pipeline.fireChannelRead(byteBuf);
                    byteBuf = null;
                } while (allocHandle.continueReading());
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
                if (allocHandle.lastBytesRead() < 0) {
                    this.closeOnRead(pipeline);
                }
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, allocHandle.lastBytesRead() < 0, allocHandle);
            }
            finally {
                if (!config.isAutoRead() && !AbstractNioByteChannel.this.isReadPending()) {
                    this.removeReadOp();
                }
            }
        }
    }
}

